/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.SoftPhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftAngularJoint
extends SoftPhysicsJoint {
    public static final Logger logger3 = Logger.getLogger(SoftAngularJoint.class.getName());
    private final Vector3f axis;

    public SoftAngularJoint(Vector3f axis, PhysicsSoftBody softA, int clusterIndexA, PhysicsRigidBody rigidB) {
        super(softA, clusterIndexA, rigidB);
        Validate.finite(axis, "axis");
        this.axis = axis.clone();
        this.createJoint();
    }

    public SoftAngularJoint(Vector3f axis, PhysicsSoftBody softA, int clusterIndexA, PhysicsSoftBody softB, int clusterIndexB) {
        super(softA, clusterIndexA, softB, clusterIndexB);
        Validate.finite(axis, "axis");
        this.axis = axis.clone();
        this.createJoint();
    }

    public Vector3f copyAxis(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.axis.clone() : storeResult.set(this.axis);
        return result;
    }

    public void setAxis(Vector3f newAxis) {
        long jointId = this.nativeId();
        this.axis.set(newAxis);
        SoftAngularJoint.setAxis(jointId, newAxis);
    }

    private void createJoint() {
        long jointId;
        PhysicsSoftBody a = this.getSoftBodyA();
        long ida = a.nativeId();
        int cia = this.clusterIndexA();
        assert (cia >= 0) : cia;
        assert (cia < a.countClusters()) : cia;
        long idb = this.getBodyB().nativeId();
        int cib = this.clusterIndexB();
        float erp = this.getERP();
        float cfm = this.getCFM();
        float split = this.getSplit();
        if (this.isSoftRigid()) {
            assert (cib == -1) : cib;
            jointId = SoftAngularJoint.createJointSoftRigid(ida, cia, idb, erp, cfm, split, this.axis);
        } else {
            PhysicsSoftBody b = this.getSoftBodyB();
            assert (cib >= 0) : cib;
            assert (cib < b.countClusters()) : cib;
            jointId = SoftAngularJoint.createJointSoftSoft(ida, cia, idb, cib, erp, cfm, split, this.axis);
        }
        this.setNativeIdNotTracked(jointId);
        assert (this.checkParameters());
    }

    private static native long createJointSoftRigid(long var0, int var2, long var3, float var5, float var6, float var7, Vector3f var8);

    private static native long createJointSoftSoft(long var0, int var2, long var3, int var5, float var6, float var7, float var8, Vector3f var9);

    private static native void setAxis(long var0, Vector3f var2);
}

