/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class SoftPhysicsJoint
extends PhysicsJoint {
    public static final Logger logger2 = Logger.getLogger(SoftPhysicsJoint.class.getName());
    private boolean added = false;
    private float cfm = 1.0f;
    private float erp = 1.0f;
    private float split = 1.0f;
    private int clusterIndexA = -1;
    private int clusterIndexB = -1;

    protected SoftPhysicsJoint(PhysicsSoftBody softBodyA, int clusterIndexA, PhysicsRigidBody rigidBodyB) {
        int numClustersA = softBodyA.countClusters();
        Validate.inRange(clusterIndexA, "cluster index", 0, numClustersA - 1);
        Validate.nonNull(rigidBodyB, "rigid body B");
        this.setBodyA(softBodyA);
        softBodyA.addJoint(this);
        this.clusterIndexA = clusterIndexA;
        this.setBodyB(rigidBodyB);
        rigidBodyB.addJoint(this);
    }

    protected SoftPhysicsJoint(PhysicsSoftBody softBodyA, int clusterIndexA, PhysicsSoftBody softBodyB, int clusterIndexB) {
        int numClustersA = softBodyA.countClusters();
        Validate.inRange(clusterIndexA, "cluster index A", 0, numClustersA - 1);
        int numClustersB = softBodyB.countClusters();
        Validate.inRange(clusterIndexB, "cluster index B", 0, numClustersB - 1);
        this.setBodyA(softBodyA);
        softBodyA.addJoint(this);
        this.clusterIndexA = clusterIndexA;
        this.setBodyB(softBodyB);
        softBodyB.addJoint(this);
        this.clusterIndexB = clusterIndexB;
    }

    public boolean checkParameters() {
        long jointId = this.nativeId();
        boolean result = this.cfm == SoftPhysicsJoint.getConstraintForceMixing(jointId) && this.erp == SoftPhysicsJoint.getErrorReductionParameter(jointId) && this.split == SoftPhysicsJoint.getSplit(jointId);
        return result;
    }

    public int clusterIndexA() {
        assert (this.clusterIndexA >= 0) : this.clusterIndexA;
        return this.clusterIndexA;
    }

    public int clusterIndexB() {
        return this.clusterIndexB;
    }

    public float getCFM() {
        return this.cfm;
    }

    public float getERP() {
        return this.erp;
    }

    public PhysicsSoftBody getSoftBodyA() {
        PhysicsBody a = this.getBodyA();
        assert (a != null);
        PhysicsSoftBody result = (PhysicsSoftBody)a;
        return result;
    }

    public PhysicsSoftBody getSoftBodyB() {
        PhysicsBody b = this.getBodyB();
        PhysicsSoftBody result = null;
        if (b instanceof PhysicsSoftBody) {
            result = (PhysicsSoftBody)b;
        }
        return result;
    }

    public float getSplit() {
        return this.split;
    }

    public boolean isSoftRigid() {
        PhysicsBody b = this.getBodyB();
        return b instanceof PhysicsRigidBody;
    }

    public boolean isSoftSoft() {
        PhysicsBody b = this.getBodyB();
        return b instanceof PhysicsSoftBody;
    }

    public void setCFM(float cfm) {
        Validate.nonNegative(cfm, "CFM coefficient");
        long jointId = this.nativeId();
        SoftPhysicsJoint.setConstraintForceMixing(jointId, cfm);
        this.cfm = cfm;
    }

    public void setERP(float erp) {
        Validate.fraction(erp, "error-reduction parameter");
        long jointId = this.nativeId();
        SoftPhysicsJoint.setErrorReductionParameter(jointId, erp);
        this.erp = erp;
    }

    public void setSplit(float split) {
        long jointId = this.nativeId();
        SoftPhysicsJoint.setSplit(jointId, split);
        this.split = split;
    }

    protected static native void finalizeNative(long var0);

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static native float getConstraintForceMixing(long var0);

    private static native float getErrorReductionParameter(long var0);

    private static native float getSplit(long var0);

    private static native void setConstraintForceMixing(long var0, float var2);

    private static native void setErrorReductionParameter(long var0, float var2);

    private static native void setSplit(long var0, float var2);
}

