/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

public enum MotorParam {
    Bounce,
    Damping,
    Equilibrium,
    LowerLimit,
    MaxMotorForce,
    MotorCfm,
    MotorErp,
    ServoTarget,
    Stiffness,
    StopCfm,
    StopErp,
    TargetVelocity,
    UpperLimit;


    public boolean canSet(float value) {
        boolean result = this.minValue() <= value && value <= this.maxValue();
        return result;
    }

    public float defaultForRotationMotor() {
        return switch (this.ordinal()) {
            case 12 -> -1.0f;
            case 0, 1, 2, 5, 7, 8, 9, 11 -> 0.0f;
            case 10 -> 0.2f;
            case 6 -> 0.9f;
            case 3 -> 1.0f;
            case 4 -> 6.0f;
            default -> throw new IllegalArgumentException(this.toString());
        };
    }

    public float defaultForTranslationMotor() {
        return switch (this.ordinal()) {
            case 0, 1, 2, 3, 4, 5, 7, 8, 9, 11, 12 -> 0.0f;
            case 10 -> 0.2f;
            case 6 -> 0.9f;
            default -> throw new IllegalArgumentException(this.toString());
        };
    }

    public float maxValue() {
        return switch (this.ordinal()) {
            case 0, 5, 6, 9, 10 -> 1.0f;
            case 1, 2, 3, 4, 7, 8, 11, 12 -> Float.MAX_VALUE;
            default -> throw new IllegalArgumentException(this.toString());
        };
    }

    public float minValue() {
        return switch (this.ordinal()) {
            case 2, 3, 7, 11, 12 -> -3.4028235E38f;
            case 0, 1, 4, 5, 6, 8, 9, 10 -> 0.0f;
            default -> throw new IllegalArgumentException(this.toString());
        };
    }

    public int nativeIndex() {
        switch (this.ordinal()) {
            case 5: {
                return 3;
            }
            case 6: {
                return 1;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 2;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }
}

