/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class TranslationMotor
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(TranslationMotor.class.getName());

    public TranslationMotor(long nativeId) {
        Validate.nonZero(nativeId, "native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public Vector3f get(MotorParam param, Vector3f storeResult) {
        long motorId = this.nativeId();
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        switch (param) {
            case Bounce: {
                TranslationMotor.getBounce(motorId, result);
                break;
            }
            case Damping: {
                TranslationMotor.getDamping(motorId, result);
                break;
            }
            case Equilibrium: {
                TranslationMotor.getEquilibrium(motorId, result);
                break;
            }
            case LowerLimit: {
                TranslationMotor.getLowerLimit(motorId, result);
                break;
            }
            case MaxMotorForce: {
                TranslationMotor.getMaxMotorForce(motorId, result);
                break;
            }
            case ServoTarget: {
                TranslationMotor.getServoTarget(motorId, result);
                break;
            }
            case Stiffness: {
                TranslationMotor.getStiffness(motorId, result);
                break;
            }
            case TargetVelocity: {
                TranslationMotor.getTargetVelocity(motorId, result);
                break;
            }
            case UpperLimit: {
                TranslationMotor.getUpperLimit(motorId, result);
                break;
            }
            default: {
                int paramIndex = param.nativeIndex();
                TranslationMotor.getParameter(motorId, paramIndex, result);
            }
        }
        return result;
    }

    public boolean isDampingLimited(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        boolean result = TranslationMotor.isDampingLimited(motorId, axisIndex);
        return result;
    }

    public boolean isMotorEnabled(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        boolean result = TranslationMotor.isMotorEnabled(motorId, axisIndex);
        return result;
    }

    public boolean isServoEnabled(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        boolean result = TranslationMotor.isServoEnabled(motorId, axisIndex);
        return result;
    }

    public boolean isSpringEnabled(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        boolean result = TranslationMotor.isSpringEnabled(motorId, axisIndex);
        return result;
    }

    public boolean isStiffnessLimited(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        boolean result = TranslationMotor.isStiffnessLimited(motorId, axisIndex);
        return result;
    }

    public void set(MotorParam param, Vector3f values) {
        Validate.nonNull(values, "value");
        long motorId = this.nativeId();
        switch (param) {
            case Bounce: {
                TranslationMotor.setBounce(motorId, values);
                break;
            }
            case Damping: {
                TranslationMotor.setDamping(motorId, values);
                break;
            }
            case Equilibrium: {
                TranslationMotor.setEquilibrium(motorId, values);
                break;
            }
            case LowerLimit: {
                TranslationMotor.setLowerLimit(motorId, values);
                break;
            }
            case MaxMotorForce: {
                TranslationMotor.setMaxMotorForce(motorId, values);
                break;
            }
            case ServoTarget: {
                TranslationMotor.setServoTarget(motorId, values);
                break;
            }
            case Stiffness: {
                TranslationMotor.setStiffness(motorId, values);
                break;
            }
            case TargetVelocity: {
                TranslationMotor.setTargetVelocity(motorId, values);
                break;
            }
            case UpperLimit: {
                TranslationMotor.setUpperLimit(motorId, values);
                break;
            }
            default: {
                int paramIndex = param.nativeIndex();
                TranslationMotor.setParameter(motorId, paramIndex, values);
            }
        }
    }

    public void setDampingLimited(int axisIndex, boolean limitDamping) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        TranslationMotor.setDampingLimited(motorId, axisIndex, limitDamping);
    }

    public void setMotorEnabled(int axisIndex, boolean enableFlag) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        TranslationMotor.setMotorEnabled(motorId, axisIndex, enableFlag);
    }

    public void setServoEnabled(int axisIndex, boolean enableFlag) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        TranslationMotor.setServoEnabled(motorId, axisIndex, enableFlag);
    }

    public void setSpringEnabled(int axisIndex, boolean enableFlag) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        TranslationMotor.setSpringEnabled(motorId, axisIndex, enableFlag);
    }

    public void setStiffnessLimited(int axisIndex, boolean limitFlag) {
        Validate.axisIndex(axisIndex, "axis index");
        long motorId = this.nativeId();
        TranslationMotor.setStiffnessLimited(motorId, axisIndex, limitFlag);
    }

    private static native void getBounce(long var0, Vector3f var2);

    private static native void getDamping(long var0, Vector3f var2);

    private static native void getEquilibrium(long var0, Vector3f var2);

    private static native void getLowerLimit(long var0, Vector3f var2);

    private static native void getMaxMotorForce(long var0, Vector3f var2);

    private static native void getParameter(long var0, int var2, Vector3f var3);

    private static native void getServoTarget(long var0, Vector3f var2);

    private static native void getStiffness(long var0, Vector3f var2);

    private static native void getTargetVelocity(long var0, Vector3f var2);

    private static native void getUpperLimit(long var0, Vector3f var2);

    private static native boolean isDampingLimited(long var0, int var2);

    private static native boolean isMotorEnabled(long var0, int var2);

    private static native boolean isServoEnabled(long var0, int var2);

    private static native boolean isSpringEnabled(long var0, int var2);

    private static native boolean isStiffnessLimited(long var0, int var2);

    private static native void setBounce(long var0, Vector3f var2);

    private static native void setDamping(long var0, Vector3f var2);

    private static native void setDampingLimited(long var0, int var2, boolean var3);

    private static native void setEquilibrium(long var0, Vector3f var2);

    private static native void setLowerLimit(long var0, Vector3f var2);

    private static native void setMaxMotorForce(long var0, Vector3f var2);

    private static native void setMotorEnabled(long var0, int var2, boolean var3);

    private static native void setParameter(long var0, int var2, Vector3f var3);

    private static native void setServoEnabled(long var0, int var2, boolean var3);

    private static native void setServoTarget(long var0, Vector3f var2);

    private static native void setSpringEnabled(long var0, int var2, boolean var3);

    private static native void setStiffness(long var0, Vector3f var2);

    private static native void setStiffnessLimited(long var0, int var2, boolean var3);

    private static native void setTargetVelocity(long var0, Vector3f var2);

    private static native void setUpperLimit(long var0, Vector3f var2);
}

