/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.MultiBody;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBodyCollider
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(MultiBodyCollider.class.getName());
    private final int linkIndex;
    private final MultiBody multiBody;

    public MultiBodyCollider(MultiBody multiBody, int linkIndex) {
        Validate.nonNull(multiBody, "multibody");
        Validate.inRange(linkIndex, "link index", -1, Integer.MAX_VALUE);
        this.multiBody = multiBody;
        this.linkIndex = linkIndex;
        assert (!this.hasAssignedNativeObject());
        this.buildObject();
    }

    public void attachShape(CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        this.setCollisionShape(shape);
        long objectId = this.nativeId();
        long shapeId = shape.nativeId();
        MultiBodyCollider.attachCollisionShape(objectId, shapeId);
    }

    public MultiBody getMultiBody() {
        assert (this.multiBody != null);
        return this.multiBody;
    }

    public int linkIndex() {
        assert (this.linkIndex >= -1) : this.linkIndex;
        return this.linkIndex;
    }

    public float mass() {
        float result = this.linkIndex >= 0 ? this.multiBody.getLink(this.linkIndex).mass() : this.multiBody.baseMass();
        assert (result > 0.0f) : result;
        return result;
    }

    public void setPhysicsLocation(Vector3f location) {
        Validate.finite(location, "location");
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsLocation(objectId, location);
    }

    public void setPhysicsLocationDp(Vec3d location) {
        Validate.finite(location, "location");
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsLocationDp(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f orientation) {
        Validate.nonNull(orientation, "orientation");
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotationDp(Matrix3d orientation) {
        Validate.nonNull(orientation, "orientation");
        long objectId = this.nativeId();
        MultiBodyCollider.setPhysicsRotationDp(objectId, orientation);
    }

    private void buildObject() {
        long multiBodyId = this.multiBody.nativeId();
        long objectId = MultiBodyCollider.createCollider(multiBodyId, this.linkIndex);
        this.setNativeId(objectId);
        assert (MultiBodyCollider.getInternalType(objectId) == 64) : MultiBodyCollider.getInternalType(objectId);
        logger2.log(Level.FINE, "Created {0}.", this);
        super.initUserPointer();
    }

    private static native long createCollider(long var0, int var2);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsLocationDp(long var0, Vec3d var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);

    private static native void setPhysicsRotationDp(long var0, Matrix3d var2);
}

