/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.objects.infos.CharacterController;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsCharacter
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(PhysicsCharacter.class.getName());
    private static final Vector3f defaultGravity = new Vector3f(0.0f, -29.4f, 0.0f);
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f unitY = new Vector3f(0.0f, 1.0f, 0.0f);
    private CharacterController controller;
    private static final ThreadLocal<Vector3f> threadTmpVector = new ThreadLocal<Vector3f>(){

        @Override
        protected Vector3f initialValue() {
            return new Vector3f();
        }
    };

    public PhysicsCharacter(ConvexShape shape, float stepHeight) {
        Validate.nonNull(shape, "shape");
        super.setCollisionShape(shape);
        this.buildObject();
        this.setStepHeight(stepHeight);
        this.setGravity(defaultGravity);
        this.setUp(unitY);
        this.warp(translateIdentity);
        assert (this.isContactResponse());
    }

    public float getAngularDamping() {
        float result = this.controller.getAngularDamping();
        return result;
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        Vector3f result = this.controller.getAngularVelocity(storeResult);
        return result;
    }

    public long getControllerId() {
        long result = this.controller.nativeId();
        return result;
    }

    public float getFallSpeed() {
        float result = this.controller.getFallSpeed();
        return result;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = this.controller.getGravity(storeResult);
        return result;
    }

    public float getJumpSpeed() {
        float result = this.controller.getJumpSpeed();
        return result;
    }

    public float getLinearDamping() {
        float result = this.controller.getLinearDamping();
        return result;
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        Vector3f result = this.controller.getLinearVelocity(storeResult);
        return result;
    }

    public float getMaxPenetrationDepth() {
        float result = this.controller.getMaxPenetrationDepth();
        return result;
    }

    public float getMaxSlope() {
        float result = this.controller.getMaxSlope();
        return result;
    }

    public float getStepHeight() {
        float result = this.controller.getStepHeight();
        return result;
    }

    public Vector3f getUpDirection(Vector3f storeResult) {
        Vector3f result = this.controller.getUpDirection(storeResult);
        return result;
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        Vector3f result = this.controller.getWalkDirection(storeResult);
        return result;
    }

    public boolean isUsingGhostSweepTest() {
        boolean result = this.controller.isUsingGhostSweepTest();
        return result;
    }

    public void jump() {
        this.jump(translateIdentity);
    }

    public void jump(Vector3f direction2) {
        this.controller.jump(direction2);
    }

    public boolean onGround() {
        boolean result = this.controller.onGround();
        return result;
    }

    public void reset(PhysicsSpace space) {
        Validate.nonNull(space, "space");
        assert (space == this.getCollisionSpace());
        this.controller.reset(space);
    }

    public void setAngularDamping(float damping) {
        this.controller.setAngularDamping(damping);
    }

    public void setAngularVelocity(Vector3f angularVelocity) {
        Validate.nonNull(angularVelocity, "angular velocity");
        this.controller.setAngularVelocity(angularVelocity);
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        assert (collisionShape.isConvex());
        assert (!this.isInWorld());
        super.setCollisionShape(collisionShape);
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            long shapeId = collisionShape.nativeId();
            PhysicsCharacter.attachCollisionShape(objectId, shapeId);
        } else {
            this.buildObject();
        }
    }

    public void setContactResponse(boolean newState) {
        int flags = this.collisionFlags();
        flags = newState ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        long objectId = this.nativeId();
        PhysicsCharacter.setCollisionFlags(objectId, flags);
    }

    public void setFallSpeed(float fallSpeed) {
        this.controller.setFallSpeed(fallSpeed);
    }

    public void setGravity(float downwardAcceleration) {
        Vector3f gVector = threadTmpVector.get();
        this.getUpDirection(gVector);
        gVector.multLocal(-downwardAcceleration);
        this.setGravity(gVector);
    }

    public void setGravity(Vector3f gravity) {
        Validate.nonNull(gravity, "gravity");
        this.controller.setGravity(gravity);
    }

    public void setJumpSpeed(float jumpSpeed) {
        this.controller.setJumpSpeed(jumpSpeed);
    }

    public void setLinearDamping(float damping) {
        this.controller.setLinearDamping(damping);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.nonNull(velocity, "velocity");
        this.controller.setLinearVelocity(velocity);
    }

    public void setMaxPenetrationDepth(float depth) {
        this.controller.setMaxPenetrationDepth(depth);
    }

    public void setMaxSlope(float slopeRadians) {
        Validate.inRange(slopeRadians, "slope radians", 0.0f, 1.5707964f);
        this.controller.setMaxSlope(slopeRadians);
    }

    public void setPhysicsLocation(Vector3f location) {
        Validate.finite(location, "location");
        this.controller.warp(location);
    }

    public void setPhysicsLocationDp(Vec3d location) {
        Validate.finite(location, "location");
        this.controller.warpDp(location);
    }

    public void setStepHeight(float height) {
        this.controller.setStepHeight(height);
    }

    public void setSweepTest(boolean useGhostSweepTest) {
        this.controller.setSweepTest(useGhostSweepTest);
    }

    public void setUp(Vector3f direction2) {
        Validate.nonZero(direction2, "direction");
        this.controller.setUp(direction2);
    }

    public void setWalkDirection(Vector3f offset) {
        Validate.nonNull(offset, "offset");
        this.controller.setWalkDirection(offset);
    }

    public void warp(Vector3f location) {
        Validate.finite(location, "location");
        this.controller.warp(location);
    }

    private void buildObject() {
        long objectId;
        if (!this.hasAssignedNativeObject()) {
            objectId = PhysicsCharacter.createGhostObject();
            this.setNativeId(objectId);
            assert (PhysicsCharacter.getInternalType(objectId) == 4) : PhysicsCharacter.getInternalType(objectId);
            logger2.log(Level.FINE, "Creating {0}.", this);
            this.initUserPointer();
        }
        objectId = this.nativeId();
        PhysicsCharacter.setCharacterFlags(objectId);
        CollisionShape shape = this.getCollisionShape();
        assert (shape.isConvex());
        long shapeId = shape.nativeId();
        PhysicsCharacter.attachCollisionShape(objectId, shapeId);
        this.controller = new CharacterController(this);
        logger2.log(Level.FINE, "Creating {0}.", this);
    }

    private static native long createGhostObject();

    private static native void setCharacterFlags(long var0);
}

