/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.objects.infos.VehicleController;
import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsVehicle
extends PhysicsRigidBody {
    public static final Logger logger3 = Logger.getLogger(PhysicsVehicle.class.getName());
    private final ArrayList<VehicleWheel> wheels = new ArrayList(6);
    private VehicleController controller;
    private final VehicleTuning tuning = new VehicleTuning();

    public PhysicsVehicle(CollisionShape shape) {
        super(shape);
    }

    public PhysicsVehicle(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public void accelerate(float force) {
        assert (this.isInWorld());
        for (VehicleWheel wheel : this.wheels) {
            this.controller.applyEngineForce(wheel, force);
        }
    }

    public void accelerate(int wheelIndex, float force) {
        Validate.inRange(wheelIndex, "wheel index", 0, this.wheels.size() - 1);
        assert (this.isInWorld());
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        this.controller.applyEngineForce(wheel, force);
    }

    public VehicleWheel addWheel(Vector3f connectionPoint, Vector3f direction2, Vector3f axle, float suspensionRestLength, float wheelRadius, boolean isFrontWheel) {
        Validate.positive(wheelRadius, "wheel radius");
        VehicleWheel result = new VehicleWheel(connectionPoint, direction2, axle, suspensionRestLength, wheelRadius, isFrontWheel);
        result.setFrictionSlip(this.tuning.getFrictionSlip());
        result.setMaxSuspensionTravelCm(this.tuning.getMaxSuspensionTravelCm());
        result.setSuspensionStiffness(this.tuning.getSuspensionStiffness());
        result.setWheelsDampingCompression(this.tuning.getSuspensionCompression());
        result.setWheelsDampingRelaxation(this.tuning.getSuspensionDamping());
        result.setMaxSuspensionForce(this.tuning.getMaxSuspensionForce());
        this.wheels.add(result);
        if (this.controller != null) {
            long controllerId = this.controller.nativeId();
            int wheelIndex = this.controller.addWheel(result, this.tuning);
            result.setVehicleId(controllerId, wheelIndex);
            assert (result.checkCopies());
        }
        return result;
    }

    public void brake(float impulse) {
        assert (this.isInWorld());
        for (VehicleWheel wheel : this.wheels) {
            this.controller.brake(wheel, impulse);
            assert (wheel.getBrake() == impulse);
        }
    }

    public void brake(int wheelIndex, float impulse) {
        Validate.inRange(wheelIndex, "wheel index", 0, this.wheels.size() - 1);
        assert (this.isInWorld());
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        this.controller.brake(wheel, impulse);
    }

    public float castRay(int wheelIndex) {
        Validate.inRange(wheelIndex, "wheel index", 0, this.wheels.size() - 1);
        assert (this.isInWorld());
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        float result = this.controller.castRay(wheel);
        return result;
    }

    public void createVehicle(PhysicsSpace space) {
        if (space == null) {
            return;
        }
        if (this.isInWorld()) assert (this.getCollisionSpace() == space);
        this.controller = new VehicleController(this, space);
        logger3.log(Level.FINE, "Created {0}", this.controller);
        this.controller.setCoordinateSystem(0, 1, 2);
        long controllerId = this.controller.nativeId();
        for (VehicleWheel wheel : this.wheels) {
            int wheelIndex = this.controller.addWheel(wheel, this.tuning);
            wheel.setVehicleId(controllerId, wheelIndex);
            assert (wheel.checkCopies());
            wheel.setSuspensionLength(0.0f);
        }
    }

    public int forwardAxisIndex() {
        assert (this.isInWorld());
        int result = this.controller.forwardAxisIndex();
        return result;
    }

    public VehicleController getController() {
        return this.controller;
    }

    public float getCurrentVehicleSpeedKmHour() {
        assert (this.isInWorld());
        float result = this.controller.getCurrentVehicleSpeedKmHour();
        return result;
    }

    public Vector3f getForwardVector(Vector3f storeResult) {
        Vector3f result = this.controller.getForwardVector(storeResult);
        return result;
    }

    public float getFrictionSlip() {
        float result = this.tuning.getFrictionSlip();
        return result;
    }

    public float getMaxSuspensionForce() {
        float result = this.tuning.getMaxSuspensionForce();
        return result;
    }

    public float getMaxSuspensionTravelCm() {
        float result = this.tuning.getMaxSuspensionTravelCm();
        return result;
    }

    public int getNumWheels() {
        assert (this.checkNumWheels());
        int result = this.wheels.size();
        return result;
    }

    public float getSuspensionCompression() {
        float result = this.tuning.getSuspensionCompression();
        return result;
    }

    public float getSuspensionDamping() {
        float result = this.tuning.getSuspensionDamping();
        return result;
    }

    public float getSuspensionStiffness() {
        float result = this.tuning.getSuspensionStiffness();
        return result;
    }

    public VehicleTuning getTuning() {
        return this.tuning;
    }

    public long getVehicleId() {
        long result = this.controller.nativeId();
        return result;
    }

    public VehicleWheel getWheel(int wheelIndex) {
        VehicleWheel result = this.wheels.get(wheelIndex);
        return result;
    }

    public void removeWheel(int wheelIndex) {
        this.wheels.remove(wheelIndex);
        this.rebuildRigidBody();
    }

    public void resetSuspension() {
        this.controller.resetSuspension();
    }

    public int rightAxisIndex() {
        int result = this.controller.rightAxisIndex();
        return result;
    }

    public void setFrictionSlip(float frictionSlip) {
        this.tuning.setFrictionSlip(frictionSlip);
    }

    public void setFrictionSlip(int wheelIndex, float frictionSlip) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setFrictionSlip(frictionSlip);
    }

    public void setMaxSuspensionForce(float maxSuspensionForce) {
        this.tuning.setMaxSuspensionForce(maxSuspensionForce);
    }

    public void setMaxSuspensionForce(int wheelIndex, float maxSuspensionForce) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setMaxSuspensionForce(maxSuspensionForce);
    }

    public void setMaxSuspensionTravelCm(float maxSuspensionTravelCm) {
        this.tuning.setMaxSuspensionTravelCm(maxSuspensionTravelCm);
    }

    public void setMaxSuspensionTravelCm(int wheelIndex, float maxSuspensionTravelCm) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setMaxSuspensionTravelCm(maxSuspensionTravelCm);
    }

    public void setRollInfluence(int wheelIndex, float rollInfluence) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setRollInfluence(rollInfluence);
    }

    public void setSuspensionCompression(float coefficient) {
        this.tuning.setSuspensionCompression(coefficient);
    }

    public void setSuspensionCompression(int wheelIndex, float coefficient) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setWheelsDampingCompression(coefficient);
    }

    public void setSuspensionDamping(float coefficient) {
        this.tuning.setSuspensionDamping(coefficient);
    }

    public void setSuspensionDamping(int wheelIndex, float coefficient) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setWheelsDampingRelaxation(coefficient);
    }

    public void setSuspensionStiffness(float coefficient) {
        this.tuning.setSuspensionStiffness(coefficient);
    }

    public void setSuspensionStiffness(int wheelIndex, float coefficient) {
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        wheel.setSuspensionStiffness(coefficient);
    }

    public void steer(float angle) {
        for (VehicleWheel wheel : this.wheels) {
            if (!wheel.isFrontWheel()) continue;
            this.controller.steer(wheel, angle);
        }
    }

    public void steer(int wheelIndex, float angle) {
        Validate.inRange(wheelIndex, "wheel index", 0, this.wheels.size() - 1);
        assert (this.isInWorld());
        VehicleWheel wheel = this.wheels.get(wheelIndex);
        this.controller.steer(wheel, angle);
    }

    public int upAxisIndex() {
        int result = this.controller.upAxisIndex();
        return result;
    }

    public void updateWheels() {
        if (this.controller != null) {
            for (VehicleWheel wheel : this.wheels) {
                this.controller.updateWheelTransform(wheel);
            }
        }
    }

    @Override
    protected void postRebuild() {
        super.postRebuild();
        RigidBodyMotionState motionState = this.getMotionState();
        motionState.setVehicle(this);
        PhysicsSpace space = (PhysicsSpace)this.getCollisionSpace();
        this.createVehicle(space);
    }

    private boolean checkNumWheels() {
        boolean result = true;
        if (this.controller != null) {
            int count;
            int size = this.wheels.size();
            result = size == (count = this.controller.countWheels());
        }
        return result;
    }
}

