/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.SoftBodyWorldInfo;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.objects.infos.SoftBodyConfig;
import com.jme3.math.Vector3f;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class ReducedDeformableBody
extends PhysicsSoftBody {
    public static final Logger logger3 = Logger.getLogger(ReducedDeformableBody.class.getName());
    private final float[] masses;
    private final Vector3f[] locations;

    public ReducedDeformableBody(Vector3f[] locations, float[] masses) {
        super(false);
        Validate.nonNull(locations, "locations");
        int numNodes = masses.length;
        Validate.require(locations.length == numNodes, "arrays of equal length");
        this.locations = new Vector3f[numNodes];
        this.masses = new float[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            this.locations[i] = locations[i].clone();
            assert (masses[i] >= 0.0f) : i;
            this.masses[i] = masses[i];
        }
        SoftBodyWorldInfo worldInfo = new SoftBodyWorldInfo();
        super.setWorldInfoInternal(worldInfo);
        long infoId = worldInfo.nativeId();
        long bodyId = ReducedDeformableBody.create(infoId, locations, masses, numNodes);
        super.setNativeId(bodyId);
        assert (ReducedDeformableBody.getInternalType(bodyId) == 8) : ReducedDeformableBody.getInternalType(bodyId);
        logger3.log(Level.FINE, "Created {0}.", this);
        SoftBodyConfig config = new SoftBodyConfig(this);
        super.setConfig(config);
        super.initUserPointer();
        float defaultMargin = CollisionShape.getDefaultMargin();
        this.setMargin(defaultMargin);
        assert (!this.isInWorld());
        assert (this.isEmpty());
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long bodyId = this.nativeId();
        ReducedDeformableBody.getLinearVelocity(bodyId, result);
        return result;
    }

    public boolean isReducedModesEnabled() {
        long bodyId = this.nativeId();
        boolean result = ReducedDeformableBody.isReducedModesEnabled(bodyId);
        return result;
    }

    public void pinNode(int nodeIndex) {
        Validate.nonNegative(nodeIndex, "node index");
        long bodyId = this.nativeId();
        ReducedDeformableBody.pinNode(bodyId, nodeIndex);
    }

    public void setDamping(float alpha, float beta) {
        long bodyId = this.nativeId();
        ReducedDeformableBody.setDamping(bodyId, alpha, beta);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.nonNull(velocity, "velocity");
        long bodyId = this.nativeId();
        ReducedDeformableBody.setLinearVelocity(bodyId, velocity);
    }

    public void setReducedModes(int numReduced, int numFull) {
        long bodyId = this.nativeId();
        ReducedDeformableBody.setReducedModes(bodyId, numReduced, numFull);
    }

    public void setReducedModesEnabled(boolean enable) {
        long bodyId = this.nativeId();
        ReducedDeformableBody.setReducedModesEnabled(bodyId, enable);
    }

    public void setStiffnessScale(float scale) {
        long bodyId = this.nativeId();
        ReducedDeformableBody.setStiffnessScale(bodyId, scale);
    }

    @Override
    protected void newEmptySoftBody() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private static native long create(long var0, Vector3f[] var2, float[] var3, int var4);

    private static native void getLinearVelocity(long var0, Vector3f var2);

    private static native boolean isReducedModesEnabled(long var0);

    private static native void pinNode(long var0, int var2);

    private static native void setDamping(long var0, float var2, float var3);

    private static native void setLinearVelocity(long var0, Vector3f var2);

    private static native void setReducedModes(long var0, int var2, int var3);

    private static native void setReducedModesEnabled(long var0, boolean var2);

    private static native void setStiffnessScale(long var0, float var2);
}

