/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class CharacterController
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(CharacterController.class.getName());
    private final PhysicsCharacter pco;

    public CharacterController(PhysicsCharacter character) {
        Validate.nonNull(character, "collision object");
        this.pco = character;
        this.createController();
    }

    public void copyAll(CharacterController source) {
        this.setAngularDamping(source.getAngularDamping());
        this.setAngularVelocity(source.getAngularVelocity(null));
        this.setFallSpeed(source.getFallSpeed());
        this.setGravity(source.getGravity(null));
        this.setJumpSpeed(source.getJumpSpeed());
        this.setLinearDamping(source.getLinearDamping());
        this.setWalkDirection(source.getWalkDirection(null));
        this.setLinearVelocity(source.getLinearVelocity(null));
        this.setMaxPenetrationDepth(source.getMaxPenetrationDepth());
        this.setMaxSlope(source.getMaxSlope());
        this.setStepHeight(source.getStepHeight());
        this.setSweepTest(source.isUsingGhostSweepTest());
        this.setUp(source.getUpDirection(null));
    }

    public float getAngularDamping() {
        long controllerId = this.nativeId();
        float result = CharacterController.getAngularDamping(controllerId);
        return result;
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getAngularVelocity(controllerId, result);
        return result;
    }

    public float getFallSpeed() {
        long controllerId = this.nativeId();
        float result = CharacterController.getFallSpeed(controllerId);
        return result;
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getGravity(controllerId, result);
        return result;
    }

    public float getJumpSpeed() {
        long controllerId = this.nativeId();
        float result = CharacterController.getJumpSpeed(controllerId);
        return result;
    }

    public float getLinearDamping() {
        long controllerId = this.nativeId();
        float result = CharacterController.getLinearDamping(controllerId);
        return result;
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getLinearVelocity(controllerId, result);
        return result;
    }

    public float getMaxPenetrationDepth() {
        long controllerId = this.nativeId();
        float result = CharacterController.getMaxPenetrationDepth(controllerId);
        return result;
    }

    public float getMaxSlope() {
        long controllerId = this.nativeId();
        float result = CharacterController.getMaxSlope(controllerId);
        return result;
    }

    public float getStepHeight() {
        long controllerId = this.nativeId();
        float result = CharacterController.getStepHeight(controllerId);
        return result;
    }

    public Vector3f getUpDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getUpDirection(controllerId, result);
        return result;
    }

    public Vector3f getWalkDirection(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long controllerId = this.nativeId();
        CharacterController.getWalkOffset(controllerId, result);
        return result;
    }

    public boolean isUsingGhostSweepTest() {
        long controllerId = this.nativeId();
        boolean result = CharacterController.isUsingGhostSweepTest(controllerId);
        return result;
    }

    public void jump(Vector3f direction2) {
        long controllerId = this.nativeId();
        CharacterController.jump(controllerId, direction2);
    }

    public boolean onGround() {
        long controllerId = this.nativeId();
        boolean result = CharacterController.onGround(controllerId);
        return result;
    }

    public void reset(PhysicsSpace space) {
        long controllerId = this.nativeId();
        long spaceId = space.nativeId();
        CharacterController.reset(controllerId, spaceId);
    }

    public void setAngularDamping(float damping) {
        long controllerId = this.nativeId();
        CharacterController.setAngularDamping(controllerId, damping);
    }

    public void setAngularVelocity(Vector3f angularVelocity) {
        long controllerId = this.nativeId();
        CharacterController.setAngularVelocity(controllerId, angularVelocity);
    }

    public void setFallSpeed(float fallSpeed) {
        long controllerId = this.nativeId();
        CharacterController.setFallSpeed(controllerId, fallSpeed);
    }

    public void setGravity(Vector3f gravity) {
        Validate.finite(gravity, "gravity");
        long controllerId = this.nativeId();
        CharacterController.setGravity(controllerId, gravity);
    }

    public void setJumpSpeed(float jumpSpeed) {
        long controllerId = this.nativeId();
        CharacterController.setJumpSpeed(controllerId, jumpSpeed);
    }

    public void setLinearDamping(float damping) {
        long controllerId = this.nativeId();
        CharacterController.setLinearDamping(controllerId, damping);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.finite(velocity, "velocity");
        long controllerId = this.nativeId();
        CharacterController.setLinearVelocity(controllerId, velocity);
    }

    public void setMaxPenetrationDepth(float depth) {
        long controllerId = this.nativeId();
        CharacterController.setMaxPenetrationDepth(controllerId, depth);
    }

    public void setMaxSlope(float slopeRadians) {
        long controllerId = this.nativeId();
        CharacterController.setMaxSlope(controllerId, slopeRadians);
    }

    public void setStepHeight(float height) {
        long controllerId = this.nativeId();
        CharacterController.setStepHeight(controllerId, height);
    }

    public void setSweepTest(boolean useGhostSweepTest) {
        long controllerId = this.nativeId();
        CharacterController.setUseGhostSweepTest(controllerId, useGhostSweepTest);
    }

    public void setUp(Vector3f direction2) {
        Validate.nonZero(direction2, "direction");
        long controllerId = this.nativeId();
        CharacterController.setUp(controllerId, direction2);
    }

    public void setWalkDirection(Vector3f offset) {
        Validate.finite(offset, "offset");
        long controllerId = this.nativeId();
        CharacterController.setWalkDirection(controllerId, offset);
    }

    public void warp(Vector3f location) {
        Validate.finite(location, "location");
        long controllerId = this.nativeId();
        CharacterController.warp(controllerId, location);
    }

    public void warpDp(Vec3d location) {
        Validate.finite(location, "location");
        long controllerId = this.nativeId();
        CharacterController.warpDp(controllerId, location);
    }

    private void createController() {
        long ghostId = this.pco.nativeId();
        long controllerId = CharacterController.create(ghostId);
        this.setNativeId(controllerId);
    }

    private static void freeNativeObject(long controllerId) {
        assert (controllerId != 0L);
        CharacterController.finalizeNative(controllerId);
    }

    private static native long create(long var0);

    private static native void finalizeNative(long var0);

    private static native float getAngularDamping(long var0);

    private static native void getAngularVelocity(long var0, Vector3f var2);

    private static native float getFallSpeed(long var0);

    private static native void getGravity(long var0, Vector3f var2);

    private static native float getJumpSpeed(long var0);

    private static native float getLinearDamping(long var0);

    private static native void getLinearVelocity(long var0, Vector3f var2);

    private static native float getMaxPenetrationDepth(long var0);

    private static native float getMaxSlope(long var0);

    private static native float getStepHeight(long var0);

    private static native void getUpDirection(long var0, Vector3f var2);

    private static native void getWalkOffset(long var0, Vector3f var2);

    private static native boolean isUsingGhostSweepTest(long var0);

    private static native void jump(long var0, Vector3f var2);

    private static native boolean onGround(long var0);

    private static native void reset(long var0, long var2);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularVelocity(long var0, Vector3f var2);

    private static native void setFallSpeed(long var0, float var2);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setJumpSpeed(long var0, float var2);

    private static native void setLinearDamping(long var0, float var2);

    private static native void setLinearVelocity(long var0, Vector3f var2);

    private static native void setMaxPenetrationDepth(long var0, float var2);

    private static native void setMaxSlope(long var0, float var2);

    private static native void setStepHeight(long var0, float var2);

    private static native void setUp(long var0, Vector3f var2);

    private static native void setUseGhostSweepTest(long var0, boolean var2);

    private static native void setWalkDirection(long var0, Vector3f var2);

    private static native void warp(long var0, Vector3f var2);

    private static native void warpDp(long var0, Vec3d var2);
}

