/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RigidBodyMotionState
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(RigidBodyMotionState.class.getName());
    private boolean applyPhysicsLocal = false;
    private PhysicsVehicle vehicle = null;

    public RigidBodyMotionState() {
        long motionStateId = RigidBodyMotionState.createMotionState();
        super.setNativeId(motionStateId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    public Vector3f getLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, result);
        assert (Vector3f.isValidVector(result));
        return result;
    }

    public Vec3d getLocationDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocationDp(motionStateId, result);
        assert (result.isFinite()) : result;
        return result;
    }

    public Matrix3f getOrientation(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotation(motionStateId, result);
        return result;
    }

    public Quaternion getOrientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, result);
        return result;
    }

    public Matrix3d getOrientationMatrixDp(Matrix3d storeResult) {
        Matrix3d result = storeResult == null ? new Matrix3d() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationDp(motionStateId, result);
        return result;
    }

    public Quatd getOrientationQuaternionDp(Quatd storeResult) {
        Quatd result = storeResult == null ? new Quatd() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationQuatDp(motionStateId, result);
        return result;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyPhysicsLocal;
    }

    public Transform physicsTransform(Transform storeResult) {
        Transform transform = storeResult == null ? new Transform() : storeResult.setScale(1.0f);
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, transform.getTranslation());
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, transform.getRotation());
        return transform;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyPhysicsLocal = applyPhysicsLocal;
    }

    public void setVehicle(PhysicsVehicle vehicle) {
        this.vehicle = vehicle;
    }

    private static void freeNativeObject(long stateId) {
        assert (stateId != 0L);
        RigidBodyMotionState.finalizeNative(stateId);
    }

    private static native boolean applyTransform(long var0, Vector3f var2, Quaternion var3);

    private static native long createMotionState();

    private static native void finalizeNative(long var0);

    private static native void getWorldLocation(long var0, Vector3f var2);

    private static native void getWorldLocationDp(long var0, Vec3d var2);

    private static native void getWorldRotation(long var0, Matrix3f var2);

    private static native void getWorldRotationDp(long var0, Matrix3d var2);

    private static native void getWorldRotationQuat(long var0, Quaternion var2);

    private static native void getWorldRotationQuatDp(long var0, Quatd var2);
}

