/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.PlaneCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.math.Plane;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public final class DebugShapeFactory {
    public static final int highResolution = 1;
    public static final int highResolution2 = 2;
    public static final int lowResolution = 0;
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(DebugShapeFactory.class.getName());
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);

    private DebugShapeFactory() {
    }

    public static FloatBuffer debugVertices(CollisionShape shape, int meshResolution) {
        FloatBuffer result;
        Validate.nonNull(shape, "shape");
        Validate.inRange(meshResolution, "mesh resolution", 0, 2);
        if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape ccs = (CompoundCollisionShape)shape;
            result = DebugShapeFactory.createCompoundVertices(ccs, meshResolution);
        } else if (shape instanceof PlaneCollisionShape) {
            float halfExt = 1000.0f;
            result = DebugShapeFactory.createPlaneVertices((PlaneCollisionShape)shape, halfExt);
        } else {
            IndexedMesh debugMesh = new IndexedMesh(shape, meshResolution);
            result = debugMesh.copyVertexPositions();
        }
        assert (result.capacity() % 3 == 0) : result.capacity();
        return result;
    }

    public static FloatBuffer getDebugTriangles(CollisionShape shape, int meshResolution) {
        FloatBuffer result;
        Validate.nonNull(shape, "shape");
        Validate.inRange(meshResolution, "mesh resolution", 0, 2);
        if (shape instanceof CompoundCollisionShape) {
            CompoundCollisionShape ccs = (CompoundCollisionShape)shape;
            result = DebugShapeFactory.createCompoundTriangles(ccs, meshResolution);
        } else if (shape instanceof PlaneCollisionShape) {
            float halfExt = 1000.0f;
            result = DebugShapeFactory.createPlaneTriangles((PlaneCollisionShape)shape, halfExt);
        } else {
            IndexedMesh debugMesh = new IndexedMesh(shape, meshResolution);
            result = debugMesh.copyTriangles();
        }
        assert (result.capacity() % 9 == 0) : result.capacity();
        return result;
    }

    public static float maxDistance(CollisionShape shape, Transform shapeToWorld, int meshResolution) {
        Validate.require(shape != null && !(shape instanceof CompoundCollisionShape) && !(shape instanceof PlaneCollisionShape), "a non-null value, neither a compound nor a plane shape");
        Validate.nonNull(shapeToWorld, "shapeToWorld");
        Validate.inRange(meshResolution, "mesh resolution", 0, 2);
        IndexedMesh debugMesh = new IndexedMesh(shape, meshResolution);
        float result = debugMesh.maxDistance(shapeToWorld);
        return result;
    }

    public static float volumeConvex(ConvexShape shape, int meshResolution) {
        Validate.nonNull(shape, "shape");
        Validate.inRange(meshResolution, "mesh resolution", 0, 2);
        IndexedMesh debugMesh = new IndexedMesh(shape, meshResolution);
        float volume = debugMesh.volumeConvex();
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    private static FloatBuffer createCompoundTriangles(CompoundCollisionShape compoundShape, int meshResolution) {
        ChildCollisionShape[] children = compoundShape.listChildren();
        int numChildren = children.length;
        FloatBuffer[] bufferArray = new FloatBuffer[numChildren];
        Transform tmpTransform = new Transform();
        int totalFloats = 0;
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            ChildCollisionShape child = children[childIndex];
            CollisionShape baseShape = child.getShape();
            child.copyTransform(tmpTransform);
            FloatBuffer buffer = DebugShapeFactory.getDebugTriangles(baseShape, meshResolution);
            int numFloats = buffer.capacity();
            MyBuffer.transform(buffer, 0, numFloats, tmpTransform);
            bufferArray[childIndex] = buffer;
            totalFloats += numFloats;
        }
        FloatBuffer result = BufferUtils.createFloatBuffer(totalFloats);
        for (FloatBuffer buffer : bufferArray) {
            for (int position = 0; position < buffer.capacity(); ++position) {
                float value = buffer.get(position);
                result.put(value);
            }
        }
        assert (result.position() == result.capacity());
        return result;
    }

    private static FloatBuffer createCompoundVertices(CompoundCollisionShape compoundShape, int meshResolution) {
        ChildCollisionShape[] children = compoundShape.listChildren();
        int numChildren = children.length;
        FloatBuffer[] bufferArray = new FloatBuffer[numChildren];
        Transform tmpTransform = new Transform();
        int totalFloats = 0;
        for (int childIndex = 0; childIndex < numChildren; ++childIndex) {
            ChildCollisionShape child = children[childIndex];
            CollisionShape baseShape = child.getShape();
            child.copyTransform(tmpTransform);
            FloatBuffer buffer = DebugShapeFactory.debugVertices(baseShape, meshResolution);
            int numFloats = buffer.capacity();
            MyBuffer.transform(buffer, 0, numFloats, tmpTransform);
            bufferArray[childIndex] = buffer;
            totalFloats += numFloats;
        }
        FloatBuffer result = BufferUtils.createFloatBuffer(totalFloats);
        for (FloatBuffer buffer : bufferArray) {
            for (int position = 0; position < buffer.capacity(); ++position) {
                float value = buffer.get(position);
                result.put(value);
            }
        }
        assert (result.position() == result.capacity());
        return result;
    }

    private static FloatBuffer createPlaneTriangles(PlaneCollisionShape shape, float halfExtent) {
        assert (shape != null);
        assert (halfExtent > 0.0f) : halfExtent;
        FloatBuffer result = BufferUtils.createFloatBuffer(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f);
        int numFloats = result.capacity();
        Transform transform = DebugShapeFactory.planeTransform(shape);
        transform.setScale(halfExtent);
        MyBuffer.transform(result, 0, numFloats, transform);
        return result;
    }

    private static FloatBuffer createPlaneVertices(PlaneCollisionShape shape, float halfExtent) {
        assert (shape != null);
        assert (halfExtent > 0.0f) : halfExtent;
        FloatBuffer result = BufferUtils.createFloatBuffer(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f);
        int numFloats = result.capacity();
        Transform transform = DebugShapeFactory.planeTransform(shape);
        transform.setScale(halfExtent);
        MyBuffer.transform(result, 0, numFloats, transform);
        return result;
    }

    private static Transform planeTransform(PlaneCollisionShape shape) {
        Transform result = new Transform();
        Plane plane = shape.getPlane();
        plane.getClosestPoint(translateIdentity, result.getTranslation());
        Vector3f v1 = plane.getNormal();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        MyVector3f.generateBasis(v1, v2, v3);
        result.getRotation().fromAxes(v1, v2, v3);
        return result;
    }
}

