/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;

public final class NativeLibrary {
    public static final Logger logger = Logger.getLogger(NativeLibrary.class.getName());
    public static final String expectedVersion = "22.0.3";

    private NativeLibrary() {
    }

    public static native int countClampedCcdMotions();

    public static native int countThreads();

    public static native void crash();

    public static native int dumpMemoryLeaks();

    public static native int dumpQuickprof();

    public static native void fail();

    public static native boolean isDebug();

    public static native boolean isDoublePrecision();

    public static native boolean isInsideTriangle(Vector3f var0, float var1, Vector3f var2, Vector3f var3, Vector3f var4);

    public static native boolean isQuickprof();

    public static native boolean isThreadSafe();

    public static native long jniEnvId();

    public static native void resetQuickprof();

    public static native void setReinitializationCallbackEnabled(boolean var0);

    public static native void setStartupMessageEnabled(boolean var0);

    public static native String versionNumber();

    private static void postInitialization() {
        String lbjVersion = NativeLibrary.versionNumber();
        if (!lbjVersion.equals(expectedVersion)) {
            logger.warning("Expected a v22.0.3 native library but loaded v" + lbjVersion + "!");
        }
        Thread physicsCleaner = new Thread("Physics Cleaner"){

            @Override
            public void run() {
                NativePhysicsObject.freeUnusedObjects();
            }
        };
        physicsCleaner.setDaemon(true);
        physicsCleaner.start();
    }

    private static void reinitialization() {
    }
}

