/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

public final class FastMath {
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;

    private FastMath() {
    }

    public static float atan(float fValue) {
        return (float)Math.atan(fValue);
    }

    public static float atan2(float fY, float fX) {
        return (float)Math.atan2(fY, fX);
    }

    public static float cos(float v) {
        return (float)Math.cos(v);
    }

    public static float sin(float v) {
        return (float)Math.sin(v);
    }

    public static float abs(float fValue) {
        if (fValue < 0.0f) {
            return -fValue;
        }
        return fValue;
    }

    public static float pow(float fBase, float fExponent) {
        return (float)Math.pow(fBase, fExponent);
    }

    public static float sqrt(float fValue) {
        return (float)Math.sqrt(fValue);
    }

    public static float tan(float fValue) {
        return (float)Math.tan(fValue);
    }

    public static float clamp(float input, float min, float max) {
        return input < min ? min : (input > max ? max : input);
    }

    public static boolean approximateEquals(float a, float b) {
        if (a == b) {
            return true;
        }
        return FastMath.abs(a - b) / Math.max(FastMath.abs(a), FastMath.abs(b)) <= 1.0E-5f;
    }
}

