/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.Serializable;
import java.util.logging.Logger;

public final class Matrix3f
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Matrix3f.class.getName());
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f();

    public Matrix3f() {
        this.loadIdentity();
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3f set(Matrix3f matrix) {
        if (null == matrix) {
            this.loadIdentity();
        } else {
            this.m00 = matrix.m00;
            this.m01 = matrix.m01;
            this.m02 = matrix.m02;
            this.m10 = matrix.m10;
            this.m11 = matrix.m11;
            this.m12 = matrix.m12;
            this.m20 = matrix.m20;
            this.m21 = matrix.m21;
            this.m22 = matrix.m22;
        }
        return this;
    }

    public float get(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public Matrix3f set(int i, int j, float value) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        this.m00 = value;
                        return this;
                    }
                    case 1: {
                        this.m01 = value;
                        return this;
                    }
                    case 2: {
                        this.m02 = value;
                        return this;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        this.m10 = value;
                        return this;
                    }
                    case 1: {
                        this.m11 = value;
                        return this;
                    }
                    case 2: {
                        this.m12 = value;
                        return this;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        this.m20 = value;
                        return this;
                    }
                    case 1: {
                        this.m21 = value;
                        return this;
                    }
                    case 2: {
                        this.m22 = value;
                        return this;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public void fromAxes(Vector3f uAxis, Vector3f vAxis, Vector3f wAxis) {
        this.m00 = uAxis.x;
        this.m10 = uAxis.y;
        this.m20 = uAxis.z;
        this.m01 = vAxis.x;
        this.m11 = vAxis.y;
        this.m21 = vAxis.z;
        this.m02 = wAxis.x;
        this.m12 = wAxis.y;
        this.m22 = wAxis.z;
    }

    public Matrix3f set(Quaternion quaternion) {
        return quaternion.toRotationMatrix(this);
    }

    public void loadIdentity() {
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f;
    }

    public Matrix3f mult(Matrix3f mat, Matrix3f product) {
        if (product == null) {
            product = new Matrix3f();
        }
        float temp00 = this.m00 * mat.m00 + this.m01 * mat.m10 + this.m02 * mat.m20;
        float temp01 = this.m00 * mat.m01 + this.m01 * mat.m11 + this.m02 * mat.m21;
        float temp02 = this.m00 * mat.m02 + this.m01 * mat.m12 + this.m02 * mat.m22;
        float temp10 = this.m10 * mat.m00 + this.m11 * mat.m10 + this.m12 * mat.m20;
        float temp11 = this.m10 * mat.m01 + this.m11 * mat.m11 + this.m12 * mat.m21;
        float temp12 = this.m10 * mat.m02 + this.m11 * mat.m12 + this.m12 * mat.m22;
        float temp20 = this.m20 * mat.m00 + this.m21 * mat.m10 + this.m22 * mat.m20;
        float temp21 = this.m20 * mat.m01 + this.m21 * mat.m11 + this.m22 * mat.m21;
        float temp22 = this.m20 * mat.m02 + this.m21 * mat.m12 + this.m22 * mat.m22;
        product.m00 = temp00;
        product.m01 = temp01;
        product.m02 = temp02;
        product.m10 = temp10;
        product.m11 = temp11;
        product.m12 = temp12;
        product.m20 = temp20;
        product.m21 = temp21;
        product.m22 = temp22;
        return product;
    }

    public Vector3f mult(Vector3f vec, Vector3f product) {
        if (null == product) {
            product = new Vector3f();
        }
        float x = vec.x;
        float y = vec.y;
        float z = vec.z;
        product.x = this.m00 * x + this.m01 * y + this.m02 * z;
        product.y = this.m10 * x + this.m11 * y + this.m12 * z;
        product.z = this.m20 * x + this.m21 * y + this.m22 * z;
        return product;
    }

    public Matrix3f multLocal(float scale) {
        this.m00 *= scale;
        this.m01 *= scale;
        this.m02 *= scale;
        this.m10 *= scale;
        this.m11 *= scale;
        this.m12 *= scale;
        this.m20 *= scale;
        this.m21 *= scale;
        this.m22 *= scale;
        return this;
    }

    public Matrix3f invert(Matrix3f store) {
        float det;
        if (store == null) {
            store = new Matrix3f();
        }
        if (FastMath.abs(det = this.determinant()) <= 1.1920929E-7f) {
            return store.zero();
        }
        store.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        store.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        store.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        store.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        store.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        store.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        store.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        store.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        store.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        store.multLocal(1.0f / det);
        return store;
    }

    public float determinant() {
        float fCo00 = this.m11 * this.m22 - this.m12 * this.m21;
        float fCo10 = this.m12 * this.m20 - this.m10 * this.m22;
        float fCo20 = this.m10 * this.m21 - this.m11 * this.m20;
        float fDet = this.m00 * fCo00 + this.m01 * fCo10 + this.m02 * fCo20;
        return fDet;
    }

    public Matrix3f zero() {
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Matrix3f\n[\n");
        result.append(" ");
        result.append(this.m00);
        result.append("  ");
        result.append(this.m01);
        result.append("  ");
        result.append(this.m02);
        result.append(" \n");
        result.append(" ");
        result.append(this.m10);
        result.append("  ");
        result.append(this.m11);
        result.append("  ");
        result.append(this.m12);
        result.append(" \n");
        result.append(" ");
        result.append(this.m20);
        result.append("  ");
        result.append(this.m21);
        result.append("  ");
        result.append(this.m22);
        result.append(" \n]");
        return result.toString();
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.m00);
        hash = 37 * hash + Float.floatToIntBits(this.m01);
        hash = 37 * hash + Float.floatToIntBits(this.m02);
        hash = 37 * hash + Float.floatToIntBits(this.m10);
        hash = 37 * hash + Float.floatToIntBits(this.m11);
        hash = 37 * hash + Float.floatToIntBits(this.m12);
        hash = 37 * hash + Float.floatToIntBits(this.m20);
        hash = 37 * hash + Float.floatToIntBits(this.m21);
        hash = 37 * hash + Float.floatToIntBits(this.m22);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Matrix3f comp = (Matrix3f)o;
        if (Float.compare(this.m00, comp.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, comp.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, comp.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m10, comp.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, comp.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, comp.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m20, comp.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, comp.m21) != 0) {
            return false;
        }
        return Float.compare(this.m22, comp.m22) == 0;
    }

    public Matrix3f clone() {
        try {
            return (Matrix3f)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

