/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.Vector3f;
import java.io.Serializable;
import java.util.logging.Logger;

public class Plane
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Plane.class.getName());
    protected Vector3f normal = new Vector3f();
    protected float constant;

    public Plane(Vector3f normal, float constant) {
        if (normal == null) {
            throw new IllegalArgumentException("normal cannot be null");
        }
        this.normal.set(normal);
        this.constant = constant;
    }

    public Plane(Vector3f normal, Vector3f displacement) {
        this(normal, displacement.dot(normal));
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public float getConstant() {
        return this.constant;
    }

    public Vector3f getClosestPoint(Vector3f point, Vector3f store) {
        float t = (this.constant - this.normal.dot(point)) / this.normal.dot(this.normal);
        return store.set(this.normal).multLocal(t).addLocal(point);
    }

    public float pseudoDistance(Vector3f point) {
        return this.normal.dot(point) - this.constant;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [Normal: " + String.valueOf(this.normal) + " - Constant: " + this.constant + "]";
    }

    public Plane clone() {
        try {
            Plane p = (Plane)super.clone();
            p.normal = this.normal.clone();
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

