/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import java.io.Serializable;

public final class Transform
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final Transform IDENTITY = new Transform();
    private Quaternion rot = new Quaternion();
    private Vector3f translation = new Vector3f();
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public Transform(Vector3f translation, Quaternion rot) {
        this.translation.set(translation);
        this.rot.set(rot);
    }

    public Transform(Vector3f translation, Quaternion rot, Vector3f scale) {
        this(translation, rot);
        this.scale.set(scale);
    }

    public Transform() {
        this(Vector3f.ZERO, Quaternion.IDENTITY);
    }

    public Transform setRotation(Quaternion rot) {
        assert (Quaternion.isValidQuaternion(rot)) : "Invalid rotation " + String.valueOf(rot);
        this.rot.set(rot);
        return this;
    }

    public Transform setTranslation(Vector3f trans) {
        assert (Vector3f.isValidVector(trans)) : "Invalid translation " + String.valueOf(trans);
        this.translation.set(trans);
        return this;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public Transform setScale(Vector3f scale) {
        assert (Vector3f.isValidVector(scale)) : "Invalid scale " + String.valueOf(scale);
        this.scale.set(scale);
        return this;
    }

    public Transform setScale(float scale) {
        assert (Float.isFinite(scale)) : "Invalid scale " + scale;
        this.scale.set(scale, scale, scale);
        return this;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public Quaternion getRotation() {
        return this.rot;
    }

    public Matrix4f toTransformMatrix() {
        return this.toTransformMatrix(null);
    }

    public Matrix4f toTransformMatrix(Matrix4f store) {
        if (store == null) {
            store = new Matrix4f();
        }
        store.setTranslation(this.translation);
        this.rot.toTransformMatrix(store);
        store.setScale(this.scale);
        return store;
    }

    public void fromTransformMatrix(Matrix4f mat) {
        TempVars vars = TempVars.get();
        this.translation.set(mat.toTranslationVector(vars.vect1));
        this.rot.set(mat.toRotationQuat(vars.quat1));
        this.scale.set(mat.toScaleVector(vars.vect2));
        vars.release();
    }

    public Transform invert() {
        Transform t = new Transform();
        t.fromTransformMatrix(this.toTransformMatrix().invertLocal());
        return t;
    }

    public void loadIdentity() {
        this.translation.set(0.0f, 0.0f, 0.0f);
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.rot.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.rot.hashCode();
        hash = 89 * hash + this.translation.hashCode();
        hash = 89 * hash + this.scale.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transform other = (Transform)obj;
        return this.translation.equals(other.translation) && this.scale.equals(other.scale) && this.rot.equals(other.rot);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.translation.x + ", " + this.translation.y + ", " + this.translation.z + "]\n[ " + this.rot.x + ", " + this.rot.y + ", " + this.rot.z + ", " + this.rot.w + "]\n[ " + this.scale.x + " , " + this.scale.y + ", " + this.scale.z + "]";
    }

    public Transform clone() {
        try {
            Transform tq = (Transform)super.clone();
            tq.rot = this.rot.clone();
            tq.scale = this.scale.clone();
            tq.translation = this.translation.clone();
            return tq;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

