/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Logger;
import jme3utilities.Validate;

public final class TransformDp {
    public static final Logger logger = Logger.getLogger(TransformDp.class.getName());
    private final Quatd rotation = new Quatd();
    private final Vec3d scaling = new Vec3d(1.0, 1.0, 1.0);
    private final Vec3d translation = new Vec3d();

    public TransformDp() {
    }

    public TransformDp(Vec3d translate, Quatd rotate) {
        Validate.nonNull(translate, "translate");
        Validate.nonNull(rotate, "rotate");
        this.rotation.set(rotate);
        this.translation.set(translate);
    }

    public TransformDp(Vec3d translate, Quatd rotate, Vec3d scale) {
        Validate.nonNull(translate, "translation");
        Validate.nonNull(rotate, "rotate");
        Validate.nonNull(scale, "scale");
        this.rotation.set(rotate);
        this.scaling.set(scale);
        this.translation.set(translate);
    }

    public TransformDp(TransformDp original) {
        Validate.nonNull(original, "original");
        this.set(original);
    }

    public TransformDp combineWithParent(TransformDp parent) {
        Vec3d parentScaling = parent.getScale();
        this.scaling.multLocal(parentScaling);
        Quatd parentRotation = parent.getRotation();
        parentRotation.mult(this.rotation, this.rotation);
        this.translation.multLocal(parentScaling);
        parentRotation.mult(this.translation, this.translation);
        this.translation.addLocal(parent.translation);
        return this;
    }

    public Quatd getRotation() {
        return this.rotation;
    }

    public Vec3d getScale() {
        return this.scaling;
    }

    public Vec3d getTranslation() {
        return this.translation;
    }

    public TransformDp loadIdentity() {
        this.rotation.set(0.0, 0.0, 0.0, 1.0);
        this.scaling.set(1.0, 1.0, 1.0);
        this.translation.set(0.0, 0.0, 0.0);
        return this;
    }

    public TransformDp set(TransformDp original) {
        Validate.nonNull(original, "original");
        this.rotation.set(original.getRotation());
        this.scaling.set(original.getScale());
        this.translation.set(original.getTranslation());
        return this;
    }

    public TransformDp set(Vec3d translate, Quatd rotate, Vec3d scale) {
        Validate.nonNull(translate, "translate");
        Validate.nonNull(rotate, "rotate");
        Validate.nonNull(scale, "scale");
        this.rotation.set(rotate);
        this.scaling.set(scale);
        this.translation.set(translate);
        return this;
    }

    public TransformDp setRotation(Quatd rotate) {
        Validate.nonNull(rotate, "rotate");
        this.rotation.set(rotate);
        return this;
    }

    public TransformDp setScale(double factor) {
        Validate.nonNull(factor, "factor");
        this.scaling.set(factor, factor, factor);
        return this;
    }

    public TransformDp setScale(Vec3d scale) {
        Validate.nonNull(scale, "scale");
        this.scaling.set(scale);
        return this;
    }

    public TransformDp setTranslation(Vec3d translate) {
        Validate.nonNull(translate, "translate");
        this.translation.set(translate);
        return this;
    }

    public Vec3d transformInverseVector(Vec3d in, Vec3d storeResult) {
        Vec3d result = storeResult == null ? in.clone() : storeResult.set(in);
        result.subtractLocal(this.translation);
        this.rotation.inverse().mult(result, result);
        result.divideLocal(this.scaling);
        return result;
    }

    public Vec3d transformVector(Vec3d in, Vec3d storeResult) {
        Vec3d result = storeResult == null ? in.clone() : storeResult.set(in);
        result.multLocal(this.scaling);
        this.rotation.mult(result, result);
        result.addLocal(this.translation);
        return result;
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            TransformDp other = (TransformDp)otherObject;
            result = this.rotation.equals(other.rotation) && this.translation.equals(other.translation) && this.scaling.equals(other.scaling);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.rotation.hashCode();
        hash = 89 * hash + this.translation.hashCode();
        hash = 89 * hash + this.scaling.hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.translation.x + ", " + this.translation.y + ", " + this.translation.z + "]\n[ " + this.rotation.x + ", " + this.rotation.y + ", " + this.rotation.z + ", " + this.rotation.w + "]\n[ " + this.scaling.x + " , " + this.scaling.y + ", " + this.scaling.z + "]";
    }
}

