/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;

public final class NativeLibraryLoader {
    public static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());

    private NativeLibraryLoader() {
    }

    public static boolean loadLibbulletjme(boolean dist, File directory, String buildType, String flavor) {
        File file;
        assert (buildType.equals("Debug") || buildType.equals("Release")) : buildType;
        assert (flavor.equals("Sp") || flavor.equals("SpMt") || flavor.equals("SpMtQuickprof") || flavor.equals("SpQuickprof") || flavor.equals("Dp") || flavor.equals("DpMt")) : flavor;
        Platform platform = JmeSystem.getPlatform();
        Platform.Os os = platform.getOs();
        Object name = switch (os) {
            case Platform.Os.Android, Platform.Os.Linux -> "libbulletjme.so";
            case Platform.Os.MacOS -> "libbulletjme.dylib";
            case Platform.Os.Windows -> "bulletjme.dll";
            default -> throw new RuntimeException("platform = " + String.valueOf((Object)platform));
        };
        if (dist) {
            name = String.valueOf((Object)platform) + buildType + flavor + "_" + (String)name;
            file = directory;
        } else {
            String subdirectory = MyString.firstToLower(platform.toString());
            file = new File(directory, subdirectory);
            String bt = MyString.firstToLower(buildType);
            file = new File(file, bt);
            String f = MyString.firstToLower(flavor);
            file = new File(file, f);
        }
        file = new File(file, (String)name);
        String absoluteFilename = file.getAbsolutePath();
        boolean success = false;
        if (!file.exists()) {
            logger.log(Level.SEVERE, "{0} does not exist", absoluteFilename);
        } else if (!file.canRead()) {
            logger.log(Level.SEVERE, "{0} is not readable", absoluteFilename);
        } else {
            logger.log(Level.INFO, "Loading native library from {0}", absoluteFilename);
            System.load(absoluteFilename);
            success = true;
        }
        return success;
    }
}

