/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Quaternion;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;

public final class Quatd
implements Cloneable {
    public double x;
    public double y;
    public double z;
    public double w;

    public Quatd() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Quatd(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quatd(Quatd quat) {
        this(quat.x, quat.y, quat.z, quat.w);
    }

    public Quatd(Quaternion quat) {
        this.x = quat.getX();
        this.y = quat.getY();
        this.z = quat.getZ();
        this.w = quat.getW();
    }

    public final Quatd clone() {
        return new Quatd(this.x, this.y, this.z, this.w);
    }

    public Quaternion toQuaternion() {
        return new Quaternion((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        bits ^= Double.doubleToLongBits(this.y) * 31L;
        bits ^= Double.doubleToLongBits(this.z) * 31L;
        return (int)(bits ^= Double.doubleToLongBits(this.w) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Quatd other = (Quatd)o;
        if (Double.compare(this.x, other.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, other.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, other.z) != 0) {
            return false;
        }
        return Double.compare(this.w, other.w) == 0;
    }

    public boolean isRotationIdentity() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.w != 0.0 && !Double.isNaN(this.w);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.w == 0.0;
    }

    public final Quatd set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public final Quatd set(Quatd q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
        return this;
    }

    public final Quatd set(Quaternion quat) {
        this.x = quat.getX();
        this.y = quat.getY();
        this.z = quat.getZ();
        this.w = quat.getW();
        return this;
    }

    public final Quatd mult(Quatd q) {
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        double qw = q.w;
        double xr = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        double yr = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        double zr = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        double wr = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        return new Quatd(xr, yr, zr, wr);
    }

    public final Quatd mult(Quatd q, Quatd result) {
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        double qw = q.w;
        double xr = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        double yr = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        double zr = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        double wr = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        if (result == null) {
            result = new Quatd(xr, yr, zr, wr);
        } else {
            result.set(xr, yr, zr, wr);
        }
        return result;
    }

    public final Quatd multLocal(Quatd q) {
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        double qw = q.w;
        double xr = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        double yr = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        double zr = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        double wr = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        this.x = xr;
        this.y = yr;
        this.z = zr;
        this.w = wr;
        return this;
    }

    public Vec3d mult(Vec3d v) {
        if (v.x == 0.0 && v.y == 0.0 && v.z == 0.0) {
            return new Vec3d();
        }
        double vx = v.x;
        double vy = v.y;
        double vz = v.z;
        double rx = this.w * this.w * vx + 2.0 * this.y * this.w * vz - 2.0 * this.z * this.w * vy + this.x * this.x * vx + 2.0 * this.y * this.x * vy + 2.0 * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
        double ry = 2.0 * this.x * this.y * vx + this.y * this.y * vy + 2.0 * this.z * this.y * vz + 2.0 * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0 * this.x * this.w * vz - this.x * this.x * vy;
        double rz = 2.0 * this.x * this.z * vx + 2.0 * this.y * this.z * vy + this.z * this.z * vz - 2.0 * this.w * this.y * vx - this.y * this.y * vz + 2.0 * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        return new Vec3d(rx, ry, rz);
    }

    public Vec3d mult(Vec3d v, Vec3d result) {
        if (v.x == 0.0 && v.y == 0.0 && v.z == 0.0) {
            if (v != result) {
                result.set(0.0, 0.0, 0.0);
            }
            return result;
        }
        double vx = v.x;
        double vy = v.y;
        double vz = v.z;
        double rx = this.w * this.w * vx + 2.0 * this.y * this.w * vz - 2.0 * this.z * this.w * vy + this.x * this.x * vx + 2.0 * this.y * this.x * vy + 2.0 * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
        double ry = 2.0 * this.x * this.y * vx + this.y * this.y * vy + 2.0 * this.z * this.y * vz + 2.0 * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0 * this.x * this.w * vz - this.x * this.x * vy;
        double rz = 2.0 * this.x * this.z * vx + 2.0 * this.y * this.z * vy + this.z * this.z * vz - 2.0 * this.w * this.y * vx - this.y * this.y * vz + 2.0 * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        result.set(rx, ry, rz);
        return result;
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final Quatd normalizeLocal() {
        double d = this.lengthSq();
        if (d == 0.0) {
            this.w = 1.0;
            return this;
        }
        double s = 1.0 / Math.sqrt(d);
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        return this;
    }

    public Matrix3d toRotationMatrix() {
        double d = this.lengthSq();
        double s = 2.0 / d;
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        double m00 = 1.0 - (yy + zz);
        double m01 = xy - zw;
        double m02 = xz + yw;
        double m10 = xy + zw;
        double m11 = 1.0 - (xx + zz);
        double m12 = yz - xw;
        double m20 = xz - yw;
        double m21 = yz + xw;
        double m22 = 1.0 - (xx + yy);
        return new Matrix3d(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public Quatd inverse() {
        double norm = this.lengthSq();
        if (norm <= 0.0) {
            return null;
        }
        double inv = 1.0 / norm;
        return new Quatd(-this.x * inv, -this.y * inv, -this.z * inv, this.w * inv);
    }

    public Quatd fromAngles(double xAngle, double yAngle, double zAngle) {
        double a = zAngle * 0.5;
        double sinZ = Math.sin(a);
        double cosZ = Math.cos(a);
        a = yAngle * 0.5;
        double sinY = Math.sin(a);
        double cosY = Math.cos(a);
        a = xAngle * 0.5;
        double sinX = Math.sin(a);
        double cosX = Math.cos(a);
        double cosYXcosZ = cosY * cosZ;
        double sinYXsinZ = sinY * sinZ;
        double cosYXsinZ = cosY * sinZ;
        double sinYXcosZ = sinY * cosZ;
        this.w = cosYXcosZ * cosX - sinYXsinZ * sinX;
        this.x = cosYXcosZ * sinX + sinYXsinZ * cosX;
        this.y = sinYXcosZ * cosX + cosYXsinZ * sinX;
        this.z = cosYXsinZ * cosX - sinYXcosZ * sinX;
        this.normalizeLocal();
        return this;
    }

    public String toString() {
        return "Quatd[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

