/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.math.Matrix3f;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;

public final class MyString {
    private static final Logger logger = Logger.getLogger(MyString.class.getName());
    private static final Pattern sciPattern = Pattern.compile("[Ee][+-]?\\d+$");
    private static final String[] axisNames = new String[]{"X", "Y", "Z"};

    private MyString() {
    }

    public static String axisName(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        String axisName = axisNames[axisIndex];
        return axisName;
    }

    public static String describe(float fValue) {
        String raw = String.format(Locale.US, "%g", Float.valueOf(fValue));
        String result = MyString.trimFloat(raw);
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static String describeFraction(float fValue) {
        String raw = String.format(Locale.US, "%.3f", Float.valueOf(fValue));
        String result = MyString.trimFloat(raw);
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static String describeMatrix(Matrix3f matrix) {
        if (matrix == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(80);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                float element = matrix.get(row, column);
                String desc = MyString.describe(element);
                result.append(desc);
                if (row >= 2 && column >= 2) continue;
                result.append(' ');
            }
            if (row >= 2) continue;
            result.append(' ');
        }
        return result.toString();
    }

    public static String escape(CharSequence unescaped) {
        int length = unescaped.length();
        StringBuilder result = new StringBuilder(length + 10);
        block6: for (int i = 0; i < length; ++i) {
            char ch = unescaped.charAt(i);
            switch (ch) {
                case '\n': {
                    result.append("\\n");
                    continue block6;
                }
                case '\t': {
                    result.append("\\t");
                    continue block6;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String firstToLower(String input) {
        Object result = input;
        if (!input.isEmpty()) {
            String first = input.substring(0, 1);
            first = first.toLowerCase(Locale.ROOT);
            String rest = input.substring(1);
            result = first + rest;
        }
        return result;
    }

    public static String quote(CharSequence text) {
        Object result = text == null ? "null" : "\"" + MyString.escape(text) + "\"";
        return result;
    }

    public static String removeSuffix(String input, String suffix) {
        Validate.nonNull(suffix, "suffix");
        if (!input.endsWith(suffix)) {
            logger.log(Level.SEVERE, "input={0}, suffix={1}", new Object[]{MyString.quote(input), MyString.quote(suffix)});
            throw new IllegalArgumentException("input must end with suffix.");
        }
        int endPosition = input.length() - suffix.length();
        String result = input.substring(0, endPosition);
        assert (result != null);
        return result;
    }

    private static String trimFloat(String input) {
        Object result;
        Matcher matcher = sciPattern.matcher(input);
        if (matcher.find()) {
            int suffixPos = matcher.start();
            String suffix = input.substring(suffixPos);
            String number = input.substring(0, suffixPos);
            result = MyString.trimFloat(number) + suffix;
        } else if (input.contains(".")) {
            int end;
            char[] chars = input.toCharArray();
            for (end = input.length(); end >= 1 && chars[end - 1] == '0'; --end) {
            }
            if (end >= 1 && chars[end - 1] == '.') {
                --end;
            }
            result = input.substring(0, end);
        } else {
            result = input;
        }
        if ("-0".equals(result)) {
            result = "0";
        }
        return result;
    }
}

