/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class Describer
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Describer.class.getName());
    private String listSeparator = " ";

    public String describe(BoundingBox aabb) {
        StringBuilder builder = new StringBuilder(80);
        builder.append("loc[");
        Vector3f location = new Vector3f();
        aabb.getCenter(location);
        String desc = MyVector3f.describe(location);
        builder.append(desc);
        builder.append(']');
        Vector3f he = aabb.getExtent(null);
        desc = this.describeHalfExtents(he);
        builder.append(desc);
        return builder.toString();
    }

    public String describeScale(Vector3f vector) {
        Validate.nonNull(vector, "vector");
        StringBuilder result = new StringBuilder(30);
        if (!MyVector3f.isScaleIdentity(vector)) {
            result.append("scale[");
            String vectorText = MyVector3f.describe(vector);
            result.append(vectorText);
            result.append(']');
        }
        return result.toString();
    }

    public String listSeparator() {
        assert (this.listSeparator != null);
        return this.listSeparator;
    }

    public void setListSeparator(String newSeparator) {
        Validate.nonNull(newSeparator, "new separator");
        this.listSeparator = newSeparator;
    }

    protected String describeHalfExtents(Vector3f he) {
        String desc = MyVector3f.describe(he);
        String result = String.format(" he[%s]", desc);
        return result;
    }

    public Describer clone() throws CloneNotSupportedException {
        Describer clone = (Describer)super.clone();
        return clone;
    }
}

