/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import java.io.PrintStream;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.debug.Describer;

public class Dumper
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Dumper.class.getName());
    private Describer describer;
    protected final PrintStream stream;
    private String indentIncrement = "  ";

    public Dumper() {
        this.describer = new Describer();
        this.stream = System.out;
    }

    public Dumper(PrintStream printStream) {
        Validate.nonNull(printStream, "print stream");
        this.describer = new Describer();
        this.stream = printStream;
    }

    public Describer getDescriber() {
        assert (this.describer != null);
        return this.describer;
    }

    public String indentIncrement() {
        assert (this.indentIncrement != null);
        return this.indentIncrement;
    }

    public Dumper setDescriber(Describer newDescriber) {
        Validate.nonNull(newDescriber, "new describer");
        this.describer = newDescriber;
        return this;
    }

    public Dumper setIndentIncrement(String newValue) {
        Validate.nonNull(newValue, "increment");
        this.indentIncrement = newValue;
        return this;
    }

    protected void addDescription(String description) {
        Validate.nonNull(description, "description");
        if (!description.isEmpty()) {
            this.stream.print(' ');
            this.stream.print(description);
        }
    }

    protected void addLine(String indent) {
        Validate.nonNull(indent, "indent");
        this.stream.println();
        this.stream.print(indent);
    }

    public Dumper clone() throws CloneNotSupportedException {
        Dumper clone = (Dumper)super.clone();
        this.describer = this.describer.clone();
        return clone;
    }
}

