/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public final class MyVolume {
    private static final float FOUR_THIRDS = 1.3333333f;
    private static final float FOUR_THIRDS_PI = 4.1887903f;
    private static final float ONE_THIRD_PI = 1.0471976f;
    public static final Logger logger = Logger.getLogger(MyVolume.class.getName());

    private MyVolume() {
    }

    public static float boxVolume(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        float volume = 8.0f * halfExtents.x * halfExtents.y * halfExtents.z;
        return volume;
    }

    public static float capsuleVolume(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float crossSection = (float)Math.PI * radius * radius;
        float volume = crossSection * (height + 1.3333333f * radius);
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    public static float coneVolume(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float volume = 1.0471976f * radius * radius * height;
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    public static float cylinderVolume(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        float volume = (float)Math.PI * 2 * halfExtents.x * halfExtents.y * halfExtents.z;
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    public static float sphereVolume(float radius) {
        Validate.nonNegative(radius, "radius");
        float volume = 4.1887903f * MyMath.cube(radius);
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    public static double tetrahedronVolume(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4) {
        Validate.finite(v1, "first vertex");
        Validate.finite(v2, "2nd vertex");
        Validate.finite(v3, "3rd vertex");
        Validate.finite(v4, "4th vertex");
        double m00 = v1.x - v4.x;
        double m01 = v1.y - v4.y;
        double m02 = v1.z - v4.z;
        double m10 = v2.x - v4.x;
        double m11 = v2.y - v4.y;
        double m12 = v2.z - v4.z;
        double m20 = v3.x - v4.x;
        double m21 = v3.y - v4.y;
        double m22 = v3.z - v4.z;
        double co00 = m11 * m22 - m12 * m21;
        double co10 = m12 * m20 - m10 * m22;
        double co20 = m10 * m21 - m11 * m20;
        double determinant = m00 * co00 + m01 * co10 + m02 * co20;
        double result = Math.abs(determinant) / 6.0;
        return result;
    }
}

