/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.CollisionConfiguration;
import com.jme3.bullet.DeformableSpace;
import com.jme3.bullet.MultiBody;
import com.jme3.bullet.MultiBodyJointType;
import com.jme3.bullet.MultiBodyLink;
import com.jme3.bullet.MultiBodySpace;
import com.jme3.bullet.PhysicsSoftSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.RayTestFlag;
import com.jme3.bullet.SoftBodyWorldInfo;
import com.jme3.bullet.SolverInfo;
import com.jme3.bullet.SolverMode;
import com.jme3.bullet.SolverType;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.GImpactCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.SimplexCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.objects.infos.Cluster;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.objects.infos.SoftBodyConfig;
import com.jme3.bullet.objects.infos.SoftBodyMaterial;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.PrintStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.debug.Describer;
import jme3utilities.debug.Dumper;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;
import jme3utilities.minie.DumpFlags;
import jme3utilities.minie.MyPco;
import jme3utilities.minie.PhysicsDescriber;

public class PhysicsDumper
extends Dumper {
    public static final Logger logger = Logger.getLogger(PhysicsDumper.class.getName());
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private boolean dumpChildShapes = false;
    private boolean dumpClustersInSofts = false;
    private boolean dumpIgnores = false;
    private boolean dumpJointsInBodies = false;
    private boolean dumpJointsInSpaces = false;
    private boolean dumpMotors = false;
    private boolean dumpNativeIDs = false;
    private boolean dumpNodesInClusters = false;
    private boolean dumpNodesInSofts = false;
    private boolean dumpPcos = true;

    public PhysicsDumper() {
        PhysicsDescriber newDescriber = new PhysicsDescriber();
        this.setDescriber(newDescriber);
    }

    public PhysicsDumper(PrintStream printStream) {
        super(printStream);
        PhysicsDescriber newDescriber = new PhysicsDescriber();
        this.setDescriber(newDescriber);
    }

    public void dump(CollisionShape shape, String indent) {
        Validate.nonNull(shape, "shape");
        Validate.nonNull(indent, "indent");
        this.addLine(indent);
        PhysicsDescriber describer = this.getDescriber();
        String desc = describer.describe(shape);
        this.stream.print(desc);
        Vector3f scale = shape.getScale(null);
        desc = describer.describeScale(scale);
        this.addDescription(desc);
        long objectId = shape.nativeId();
        this.addNativeId(objectId);
        if (this.dumpChildShapes && shape instanceof CompoundCollisionShape) {
            String moreIndent = indent + this.indentIncrement();
            this.dumpChildren((CompoundCollisionShape)shape, moreIndent);
        }
    }

    public void dump(MultiBodyCollider collider, String indent) {
        Validate.nonNull(collider, "collider");
        Validate.nonNull(indent, "indent");
        this.addLine(indent);
        this.stream.print("Collider");
        PhysicsDescriber describer = this.getDescriber();
        String desc = describer.describeUser(collider);
        this.stream.print(desc);
        if (!collider.isActive()) {
            this.stream.print("/inactive");
        }
        if (!collider.isContactResponse()) {
            this.stream.print("/NOresponse");
        }
        if (!collider.isInWorld()) {
            this.stream.print("/NOspace");
        }
        float mass = collider.mass();
        String massText = MyString.describe(mass);
        this.stream.printf(" mass=%s", massText);
        Vector3f loc = collider.getPhysicsLocation(null);
        this.stream.printf(" loc[%s]", MyVector3f.describe(loc));
        desc = describer.describeGroups(collider);
        this.stream.print(desc);
        this.addUserIndices(collider);
        long objectId = collider.nativeId();
        this.addNativeId(objectId);
        CollisionShape shape = collider.getCollisionShape();
        this.dump(shape, indent + " ");
    }

    public void dump(PhysicsCharacter character, String indent) {
        Validate.nonNull(character, "character");
        Validate.nonNull(indent, "indent");
        this.stream.printf("%n%sCharacter", indent);
        PhysicsDescriber describer = this.getDescriber();
        String desc = describer.describeUser(character);
        this.stream.print(desc);
        Vector3f location = character.getPhysicsLocation(null);
        String locString = MyVector3f.describe(location);
        this.stream.printf(" loc[%s]", locString);
        Vector3f walk = character.getWalkDirection(null);
        this.stream.printf(" walk[%s]", MyVector3f.describeDirection(walk));
        Vector3f lin = character.getLinearVelocity(null);
        this.stream.printf(" v[%s]", MyVector3f.describe(lin));
        Vector3f ang = character.getAngularVelocity(null);
        this.stream.printf(" angV[%s]", MyVector3f.describe(ang));
        this.addUserIndices(character);
        long objectId = character.nativeId();
        this.addNativeId(objectId);
        this.addLine(indent);
        Vector3f grav = character.getGravity(null);
        this.stream.printf(" grav[%s]", MyVector3f.describe(grav));
        Vector3f up = character.getUpDirection(null);
        this.stream.printf(" up[%s]", MyVector3f.describeDirection(up));
        this.stream.print(" jumpSp=");
        float jump = character.getJumpSpeed();
        this.stream.print(MyString.describe(jump));
        float angularDamping = character.getAngularDamping();
        float linearDamping = character.getLinearDamping();
        this.stream.print("] damp[l=");
        this.stream.print(MyString.describe(linearDamping));
        this.stream.print(" a=");
        this.stream.print(MyString.describe(angularDamping));
        this.stream.print("] max[fallSp=");
        float fall = character.getFallSpeed();
        this.stream.print(MyString.describe(fall));
        this.stream.print(" pen=");
        float maxPen = character.getMaxPenetrationDepth();
        this.stream.print(MyString.describe(maxPen));
        this.stream.print(" slope=");
        float maxSlope = character.getMaxSlope();
        this.stream.print(MyString.describe(maxSlope));
        this.stream.print(" stepHt=");
        float maxStepHt = character.getStepHeight();
        this.stream.print(MyString.describe(maxStepHt));
        this.stream.print("] ");
        boolean gsTest = character.isUsingGhostSweepTest();
        if (!gsTest) {
            this.stream.print("NO");
        }
        this.stream.print("gsTest");
        desc = describer.describeGroups(character);
        this.stream.print(desc);
        CollisionShape shape = character.getCollisionShape();
        this.dump(shape, indent + " ");
        this.addLine(indent);
        int numIgnores = character.countIgnored();
        this.stream.printf(" with %d ignore%s", numIgnores, numIgnores == 1 ? "" : "s");
        if (this.dumpIgnores && numIgnores > 0) {
            this.dumpIgnores(character, indent);
        }
    }

    public void dump(PhysicsGhostObject ghost, String indent) {
        Validate.nonNull(ghost, "ghost");
        Validate.nonNull(indent, "indent");
        this.stream.printf("%n%sGhost", indent);
        PhysicsDescriber describer = this.getDescriber();
        String desc = describer.describeUser(ghost);
        this.stream.print(desc);
        Vector3f location = ghost.getPhysicsLocation(null);
        String locString = MyVector3f.describe(location);
        this.stream.printf(" loc[%s]", locString);
        Quaternion orientation = ghost.getPhysicsRotation(null);
        if (!MyQuaternion.isRotationIdentity(orientation)) {
            String orientText = MyQuaternion.describe(orientation);
            this.stream.printf(" orient[%s]", orientText);
        }
        this.addUserIndices(ghost);
        long objectId = ghost.nativeId();
        this.addNativeId(objectId);
        CollisionShape shape = ghost.getCollisionShape();
        this.dump(shape, indent + " ");
        this.addLine(indent);
        if (shape instanceof CompoundCollisionShape || shape instanceof GImpactCollisionShape || shape instanceof HeightfieldCollisionShape || shape instanceof HullCollisionShape || shape instanceof MeshCollisionShape || shape instanceof SimplexCollisionShape) {
            BoundingBox aabb = shape.boundingBox(location, orientation, null);
            desc = describer.describe(aabb);
            this.stream.printf(" aabb[%s]", desc);
        }
        desc = describer.describeGroups(ghost);
        this.stream.print(desc);
        int numIgnores = ghost.countIgnored();
        this.stream.printf(" with %d ignore%s", numIgnores, numIgnores == 1 ? "" : "s");
        if (this.dumpIgnores && numIgnores > 0) {
            this.dumpIgnores(ghost, indent);
        }
    }

    public void dump(PhysicsJoint joint, String indent) {
        block6: {
            String mmIndent;
            String desc;
            PhysicsDescriber describer;
            String moreIndent;
            block5: {
                Validate.nonNull(joint, "joint");
                Validate.nonNull(indent, "indent");
                moreIndent = indent + this.indentIncrement();
                this.addLine(moreIndent);
                describer = this.getDescriber();
                desc = describer.describeJointInSpace(joint, this.dumpNativeIDs);
                this.stream.print(desc);
                mmIndent = moreIndent + this.indentIncrement();
                if (!(joint instanceof SixDofJoint)) break block5;
                SixDofJoint sixDof = (SixDofJoint)joint;
                desc = describer.describeAngular(sixDof);
                this.stream.printf("%n%s %s", moreIndent, desc);
                desc = describer.describeLinear(sixDof);
                this.stream.printf("%n%s %s", moreIndent, desc);
                if (!this.dumpMotors) break block6;
                for (int axisI = 0; axisI < 3; ++axisI) {
                    String axisName = MyString.axisName(axisI);
                    this.stream.printf("%n%srot%s: ", mmIndent, axisName);
                    RotationalLimitMotor motor = sixDof.getRotationalLimitMotor(axisI);
                    desc = describer.describe(motor);
                    this.stream.print(desc);
                }
                TranslationalLimitMotor motor = sixDof.getTranslationalLimitMotor();
                for (int axisI = 0; axisI < 3; ++axisI) {
                    String axisName = MyString.axisName(axisI);
                    this.stream.printf("%n%stra%s: ", mmIndent, axisName);
                    desc = describer.describe(motor, axisI);
                    this.stream.print(desc);
                }
                break block6;
            }
            if (joint instanceof New6Dof) {
                New6Dof sixDof = (New6Dof)joint;
                this.addLine(moreIndent);
                Vector3f offset = sixDof.getPivotOffset(null);
                this.stream.printf(" offset[%s]", MyVector3f.describe(offset));
                Vector3f locA = sixDof.calculatedOriginA(null);
                this.stream.printf(" locA[%s]", MyVector3f.describe(locA));
                Vector3f locB = sixDof.calculatedOriginB(null);
                this.stream.printf(" locB[%s]", MyVector3f.describe(locB));
                this.addLine(moreIndent);
                Vector3f angles = sixDof.getAngles(null);
                this.stream.printf(" angles[%s]", MyVector3f.describe(angles));
                desc = sixDof.getRotationOrder().toString();
                this.stream.printf(" ro=%s", desc);
                Matrix3f basA = sixDof.calculatedBasisA(null);
                this.stream.printf(" basA[%s]", MyString.describeMatrix(basA));
                Matrix3f basB = sixDof.calculatedBasisB(null);
                this.stream.printf(" basB[%s]", MyString.describeMatrix(basB));
                if (this.dumpMotors) {
                    for (int dofIndex = 0; dofIndex < 6; ++dofIndex) {
                        int axisIndex = dofIndex % 3;
                        String tr = dofIndex < 3 ? "T" : "R";
                        String axisName = MyString.axisName(axisIndex);
                        this.stream.printf("%n%s%s%s:", mmIndent, tr, axisName);
                        desc = describer.describeDof(sixDof, dofIndex);
                        this.stream.print(desc);
                    }
                }
            }
        }
    }

    public void dump(PhysicsRigidBody body, String indent) {
        Quaternion orientation;
        Validate.nonNull(body, "body");
        Validate.nonNull(indent, "indent");
        this.addLine(indent);
        if (body instanceof PhysicsVehicle) {
            this.stream.print("Vehicle ");
        } else {
            this.stream.print("Rigid ");
        }
        String desc = MyPco.describe(body);
        this.stream.print(desc);
        PhysicsDescriber describer = this.getDescriber();
        desc = describer.describeUser(body);
        this.stream.print(desc);
        RigidBodyMotionState motionState = body.getMotionState();
        Vector3f msLoc = motionState.getLocation(null);
        String locString = MyVector3f.describe(msLoc);
        this.stream.printf(" msLoc[%s]", locString);
        Vector3f location = body.getPhysicsLocation(null);
        if (!location.equals(msLoc)) {
            locString = MyVector3f.describe(location);
            this.stream.printf(" loc[%s]", locString);
        }
        if (!MyQuaternion.isRotationIdentity(orientation = body.getPhysicsRotation(null))) {
            String orientText = MyQuaternion.describe(orientation);
            this.stream.printf(" orient[%s]", orientText);
        }
        this.addUserIndices(body);
        long objectId = body.nativeId();
        this.addNativeId(objectId);
        this.addLine(indent);
        this.addActivationState(body);
        this.addContactParameters(body);
        if (body.isDynamic()) {
            this.addDynamicProperties(body, indent);
        }
        CollisionShape shape = body.getCollisionShape();
        this.dump(shape, indent + " ");
        this.addLine(indent);
        if (shape instanceof CompoundCollisionShape || shape instanceof GImpactCollisionShape || shape instanceof HeightfieldCollisionShape || shape instanceof HullCollisionShape || shape instanceof MeshCollisionShape || shape instanceof SimplexCollisionShape) {
            BoundingBox aabb = shape.boundingBox(location, orientation, null);
            desc = describer.describe(aabb);
            this.stream.printf(" aabb[%s]", desc);
        }
        desc = describer.describeGroups(body);
        this.stream.print(desc);
        this.stream.print(" with");
        if (body instanceof PhysicsVehicle) {
            PhysicsVehicle vehicle = (PhysicsVehicle)body;
            int numWheels = vehicle.getNumWheels();
            this.stream.printf(" %d wheel%s", numWheels, numWheels == 1 ? "" : "s");
            if (numWheels > 0) {
                this.dumpWheels(vehicle, indent, numWheels);
            } else {
                this.stream.print(',');
            }
        }
        int numIgnores = body.countIgnored();
        this.stream.printf(" %d ignore%s", numIgnores, numIgnores == 1 ? "" : "s");
        if (this.dumpIgnores && numIgnores > 0) {
            this.dumpIgnores(body, indent);
        }
        int numJoints = body.countJoints();
        this.stream.printf(" and %d joint%s", numJoints, numJoints == 1 ? "" : "s");
        if (this.dumpJointsInBodies && numJoints > 0) {
            this.dumpJoints(body, indent);
        }
    }

    public void dump(PhysicsSoftBody body, String indent) {
        Validate.nonNull(body, "body");
        Validate.nonNull(indent, "indent");
        this.stream.printf("%n%sSoft ", indent);
        PhysicsDescriber describer = this.getDescriber();
        BoundingBox aabb = body.boundingBox(null);
        String desc = describer.describe(aabb);
        this.stream.print(desc);
        this.stream.print(" mass=");
        float mass = body.getMass();
        desc = MyString.describe(mass);
        this.stream.print(desc);
        this.stream.print(" marg=");
        float margin = body.margin();
        desc = MyString.describe(margin);
        this.stream.print(desc);
        this.addUserIndices(body);
        long objectId = body.nativeId();
        this.addNativeId(objectId);
        this.stream.printf("%n%s  vol=", indent);
        float volume = body.volume();
        desc = MyString.describe(volume);
        this.stream.print(desc);
        this.stream.print(" wind[");
        Vector3f wind = body.windVelocity(null);
        desc = MyVector3f.describe(wind);
        this.stream.print(desc);
        this.stream.print(']');
        desc = describer.describeUser(body);
        this.stream.print(desc);
        int numLinks = body.countLinks();
        int numFaces = body.countFaces();
        int numTetras = body.countTetras();
        this.stream.printf(" with %d link%s, %d face%s, %d tetra%s", numLinks, numLinks == 1 ? "" : "s", numFaces, numFaces == 1 ? "" : "s", numTetras, numTetras == 1 ? "" : "s");
        Quaternion orientation = body.getPhysicsRotation(null);
        if (!MyQuaternion.isRotationIdentity(orientation)) {
            desc = MyQuaternion.describe(orientation);
            this.stream.printf(" orient[%s]", desc);
        }
        SoftBodyConfig config = body.getSoftConfig();
        desc = describer.describe1(config);
        this.stream.printf("%n%s %s", indent, desc);
        desc = describer.describe2(config);
        this.stream.printf("%n%s %s", indent, desc);
        SoftBodyMaterial material = body.getSoftMaterial();
        desc = describer.describe(material);
        this.stream.printf("%n%s %s", indent, desc);
        SoftBodyWorldInfo info = body.getWorldInfo();
        desc = describer.describe(info);
        this.stream.printf("%n%s %s ", indent, desc);
        if (!body.isWorldInfoProtected()) {
            this.stream.print("NOT");
        }
        this.stream.print("protected");
        objectId = info.nativeId();
        this.addNativeId(objectId);
        desc = describer.describeGroups(body);
        this.stream.printf("%n%s%s", indent, desc);
        int numJoints = body.countJoints();
        this.stream.printf(" with %d joint%s", numJoints, numJoints == 1 ? "" : "s");
        if (this.dumpJointsInBodies && numJoints > 0) {
            this.dumpJoints(body, indent);
            this.addLine(indent);
        } else {
            this.stream.print(',');
        }
        int numClusters = body.countClusters();
        this.stream.printf(" %d cluster%s", numClusters, numClusters == 1 ? "" : "s");
        if (this.dumpClustersInSofts && numClusters > 0) {
            this.dumpClusters(body, indent);
        } else {
            this.stream.print(',');
        }
        int numNodes = body.countNodes();
        this.stream.printf(" %d node%s", numNodes, numNodes == 1 ? "" : "s");
        int numPinned = body.countPinnedNodes();
        if (numPinned > 0) {
            this.stream.printf(" (%d pinned)", numPinned);
        }
        if (this.dumpNodesInSofts && numNodes > 0) {
            this.dumpNodes(body, indent);
        }
    }

    public void dump(PhysicsSpace space) {
        this.dump(space, "");
    }

    public void dump(PhysicsSpace space, String indent) {
        Validate.nonNull(indent, "indent");
        String type = space.getClass().getSimpleName();
        Collection<PhysicsCharacter> characters = space.getCharacterList();
        int numCharacters = characters.size();
        Collection<PhysicsGhostObject> ghosts = space.getGhostObjectList();
        int numGhosts = ghosts.size();
        this.stream.printf("%n%s%s with %d char%s, %d ghost%s, ", indent, type, numCharacters, numCharacters == 1 ? "" : "s", numGhosts, numGhosts == 1 ? "" : "s");
        Collection<PhysicsJoint> joints = space.getJointList();
        int numJoints = joints.size();
        this.stream.printf("%d joint%s, ", numJoints, numJoints == 1 ? "" : "s");
        Collection<Object> multibodies = new ArrayList(0);
        if (space instanceof MultiBodySpace) {
            multibodies = ((MultiBodySpace)space).getMultiBodyList();
            int numMultis = multibodies.size();
            this.stream.printf("%d multi%s, ", numMultis, numMultis == 1 ? "" : "s");
        }
        Collection<PhysicsRigidBody> rigidBodies = space.getRigidBodyList();
        int numRigids = rigidBodies.size();
        this.stream.printf("%d rigid%s, ", numRigids, numRigids == 1 ? "" : "s");
        Collection<Object> softBodies = new ArrayList(0);
        if (space instanceof PhysicsSoftSpace) {
            softBodies = ((PhysicsSoftSpace)space).getSoftBodyList();
            numSofts = softBodies.size();
            this.stream.printf("%d soft%s, ", numSofts, numSofts == 1 ? "" : "s");
        } else if (space instanceof DeformableSpace) {
            softBodies = ((DeformableSpace)space).getSoftBodyList();
            numSofts = softBodies.size();
            this.stream.printf("%d soft%s, ", numSofts, numSofts == 1 ? "" : "s");
        }
        int numVehicles = space.getVehicleList().size();
        this.stream.printf("%d vehicle%s", numVehicles, numVehicles == 1 ? "" : "s");
        long spaceId = space.nativeId();
        this.addNativeId(spaceId);
        this.addLine(indent);
        PhysicsSpace.BroadphaseType bphase = space.getBroadphaseType();
        this.stream.printf(" bphase=%s", new Object[]{bphase});
        Vector3f grav = space.getGravity(null);
        this.stream.printf(" grav[%s] timeStep[", MyVector3f.describe(grav));
        int maxSS = space.maxSubSteps();
        if (maxSS == 0) {
            float maxTimeStep = space.maxTimeStep();
            String mtsDesc = MyString.describe(maxTimeStep);
            this.stream.printf("VAR max=%s", mtsDesc);
        } else {
            float accuracy = space.getAccuracy();
            String accuDesc = MyString.describe(accuracy);
            this.stream.printf("%s maxSS=%d", accuDesc, maxSS);
        }
        int tCount = space.countTickListeners();
        this.stream.printf("] listeners=%d", tCount);
        this.addLine(indent);
        SolverType solverType = space.getSolverType();
        SolverInfo solverInfo = space.getSolverInfo();
        int iters = solverInfo.numIterations();
        float cfm = solverInfo.globalCfm();
        this.stream.printf(" solver[%s iters=%d cfm=%s", new Object[]{solverType, iters, MyString.describe(cfm)});
        int batch = solverInfo.minBatch();
        this.stream.printf(" batch=%d splitImp[th=", batch);
        boolean enabledGlobally = solverInfo.isSplitImpulseEnabled();
        if (enabledGlobally) {
            this.stream.print("global");
        } else {
            float th = solverInfo.splitImpulseThreshold();
            this.stream.print(MyString.describe(th));
        }
        float erp = solverInfo.splitImpulseErp();
        this.stream.printf(" erp=%s]", MyString.describe(erp));
        int mode = solverInfo.mode();
        this.stream.printf(" mode=%s]", SolverMode.describe(mode));
        CollisionConfiguration configuration = space.getConfiguration();
        PhysicsDescriber describer = this.getDescriber();
        String confDesc = describer.describe(configuration);
        this.stream.printf("%n%s conf[%s]", indent, confDesc);
        if (space.isCcdWithStaticOnly()) {
            this.stream.print(" CCDwso");
        }
        if (space.isUsingDeterministicDispatch()) {
            this.stream.print(" DeterministicDispatch");
        }
        if (space.isUsingScr()) {
            this.stream.print(" SCR");
        }
        int rayTestFlags = space.getRayTestFlags();
        String rayTest = RayTestFlag.describe(rayTestFlags);
        this.stream.printf(" rayTest=%s", rayTest);
        if (bphase == PhysicsSpace.BroadphaseType.AXIS_SWEEP_3 || bphase == PhysicsSpace.BroadphaseType.AXIS_SWEEP_3_32) {
            Vector3f worldMin = space.getWorldMin(null);
            String minDesc = MyVector3f.describe(worldMin);
            Vector3f vector3f = space.getWorldMax(null);
            String maxDesc = MyVector3f.describe(vector3f);
            this.stream.printf(" worldMin[%s] worldMax[%s]", minDesc, maxDesc);
        }
        if (space instanceof PhysicsSoftSpace) {
            SoftBodyWorldInfo info = ((PhysicsSoftSpace)space).getWorldInfo();
            String infoDesc = describer.describe(info);
            this.stream.printf("%n%s %s", indent, infoDesc);
            long l = info.nativeId();
            this.addNativeId(l);
        }
        if (this.dumpPcos) {
            String moreIndent = indent + this.indentIncrement();
            for (PhysicsCharacter physicsCharacter : characters) {
                this.dump(physicsCharacter, moreIndent);
            }
            for (PhysicsGhostObject physicsGhostObject : ghosts) {
                this.dump(physicsGhostObject, moreIndent);
            }
            for (MultiBody multiBody : multibodies) {
                this.dumpMultiBody(multiBody, moreIndent);
            }
            for (PhysicsRigidBody physicsRigidBody : rigidBodies) {
                this.dump(physicsRigidBody, moreIndent);
            }
            for (PhysicsSoftBody physicsSoftBody : softBodies) {
                this.dump(physicsSoftBody, moreIndent);
            }
        }
        if (this.dumpJointsInSpaces) {
            this.dumpJoints(joints, indent);
        }
        this.stream.println();
    }

    public boolean isEnabled(DumpFlags dumpFlag) {
        return switch (dumpFlag) {
            case DumpFlags.ChildShapes -> this.dumpChildShapes;
            case DumpFlags.ClustersInSofts -> this.dumpClustersInSofts;
            case DumpFlags.Ignores -> this.dumpIgnores;
            case DumpFlags.JointsInBodies -> this.dumpJointsInBodies;
            case DumpFlags.JointsInSpaces -> this.dumpJointsInSpaces;
            case DumpFlags.Motors -> this.dumpMotors;
            case DumpFlags.NativeIDs -> this.dumpNativeIDs;
            case DumpFlags.NodesInClusters -> this.dumpNodesInClusters;
            case DumpFlags.NodesInSofts -> this.dumpNodesInSofts;
            case DumpFlags.Pcos -> this.dumpPcos;
            default -> throw new IllegalArgumentException("dumpFlag = " + String.valueOf((Object)dumpFlag));
        };
    }

    public PhysicsDumper setEnabled(DumpFlags dumpFlag, boolean newValue) {
        switch (dumpFlag) {
            case ChildShapes: {
                this.dumpChildShapes = newValue;
                break;
            }
            case ClustersInSofts: {
                this.dumpClustersInSofts = newValue;
                break;
            }
            case Ignores: {
                this.dumpIgnores = newValue;
                break;
            }
            case JointsInBodies: {
                this.dumpJointsInBodies = newValue;
                break;
            }
            case JointsInSpaces: {
                this.dumpJointsInSpaces = newValue;
                break;
            }
            case Motors: {
                this.dumpMotors = newValue;
                break;
            }
            case NativeIDs: {
                this.dumpNativeIDs = newValue;
                break;
            }
            case NodesInClusters: {
                this.dumpNodesInClusters = newValue;
                break;
            }
            case NodesInSofts: {
                this.dumpNodesInSofts = newValue;
                break;
            }
            case Pcos: {
                this.dumpPcos = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("dumpFlag = " + String.valueOf((Object)dumpFlag));
            }
        }
        return this;
    }

    @Override
    public PhysicsDumper clone() throws CloneNotSupportedException {
        PhysicsDumper clone = (PhysicsDumper)super.clone();
        return clone;
    }

    @Override
    public PhysicsDescriber getDescriber() {
        Describer describer = super.getDescriber();
        PhysicsDescriber result = (PhysicsDescriber)describer;
        return result;
    }

    private void addActivationState(PhysicsRigidBody body) {
        int expectedState = body.isKinematic() || body instanceof PhysicsVehicle ? 4 : (body.isActive() ? 1 : 2);
        int activationState = body.getActivationState();
        if (activationState != expectedState) {
            this.stream.printf(" act=%d", activationState);
        }
    }

    private void addContactParameters(PhysicsRigidBody body) {
        float fric = body.getFriction();
        this.stream.print(" contact[fric=");
        this.stream.print(MyString.describe(fric));
        float rest = body.getRestitution();
        this.stream.print(" rest=");
        this.stream.print(MyString.describe(rest));
        float damp = body.getContactDamping();
        this.stream.print(" damp=");
        this.stream.print(MyString.describe(damp));
        float pth = body.getContactProcessingThreshold();
        this.stream.print(" pth=");
        this.stream.print(MyString.describe(pth));
        float stiff = body.getContactStiffness();
        this.stream.print(" stiff=");
        this.stream.print(MyString.describe(stiff));
        this.stream.print(']');
    }

    private void addDynamicProperties(PhysicsRigidBody rigidBody, String indent) {
        this.addLine(indent);
        Vector3f grav = rigidBody.getGravity(null);
        String gravString = MyVector3f.describe(grav);
        this.stream.printf(" grav[%s] ", gravString);
        if (!rigidBody.isGravityProtected()) {
            this.stream.print("NOT");
        }
        this.stream.print("protected ccd[mth=");
        float ccdMt = rigidBody.getCcdMotionThreshold();
        this.stream.print(MyString.describe(ccdMt));
        if (ccdMt > 0.0f) {
            this.stream.print(" r=");
            float ccdR = rigidBody.getCcdSweptSphereRadius();
            this.stream.print(MyString.describe(ccdR));
        }
        float angularDamping = rigidBody.getAngularDamping();
        float linearDamping = rigidBody.getLinearDamping();
        this.stream.print("] damp[l=");
        this.stream.print(MyString.describe(linearDamping));
        this.stream.print(" a=");
        this.stream.print(MyString.describe(angularDamping));
        float linearThreshold = rigidBody.getLinearSleepingThreshold();
        float angularThreshold = rigidBody.getAngularSleepingThreshold();
        this.stream.print("] sleep[lth=");
        this.stream.print(MyString.describe(linearThreshold));
        this.stream.print(" ath=");
        this.stream.print(MyString.describe(angularThreshold));
        if (rigidBody.isActive()) {
            float deactivationTime = rigidBody.getDeactivationTime();
            this.stream.print(" time=");
            this.stream.print(MyString.describe(deactivationTime));
        }
        this.stream.print(']');
        this.addLine(indent);
        Vector3f v = rigidBody.getLinearVelocity(null);
        this.stream.printf(" v[%s]", MyVector3f.describe(v));
        Vector3f force = rigidBody.totalAppliedForce(null);
        this.stream.printf(" force[%s]", MyVector3f.describe(force));
        Vector3f lFact = rigidBody.getLinearFactor(null);
        if (!MyVector3f.isScaleUniform(lFact)) {
            this.stream.printf(" lFact[%s]", MyVector3f.describe(lFact));
        }
        this.addLine(indent);
        this.stream.print(" inert[");
        Vector3f iiLocal = rigidBody.getInverseInertiaLocal(null);
        Vector3f inert = scaleIdentity.divide(iiLocal);
        this.stream.print(MyVector3f.describe(inert));
        this.stream.print(']');
        Vector3f angularVelocity = rigidBody.getAngularVelocity(null);
        this.stream.printf(" w[%s]", MyVector3f.describe(angularVelocity));
        Vector3f torq = rigidBody.totalAppliedTorque(null);
        this.stream.printf(" torq[%s]", MyVector3f.describe(torq));
        Vector3f aFact = rigidBody.getAngularFactor(null);
        if (!MyVector3f.isScaleUniform(aFact)) {
            this.stream.printf(" aFact[%s]", MyVector3f.describe(aFact));
        }
    }

    private void addNativeId(long id) {
        if (this.dumpNativeIDs) {
            this.stream.print(" #");
            String hex = Long.toHexString(id);
            this.stream.print(hex);
        }
    }

    private void addUserIndices(PhysicsCollisionObject pco) {
        int userIndex3;
        int userIndex2;
        int userIndex = pco.userIndex();
        if (userIndex != -1) {
            this.stream.print(" userIndex=");
            this.stream.print(userIndex);
        }
        if ((userIndex2 = pco.userIndex2()) != -1) {
            this.stream.print(" userIndex2=");
            this.stream.print(userIndex2);
        }
        if ((userIndex3 = pco.userIndex3()) != -1) {
            this.stream.print(" userIndex3=");
            this.stream.print(userIndex3);
        }
    }

    private static String describeVector(FloatBuffer buffer, int vectorIndex) {
        Vector3f vector = new Vector3f();
        MyBuffer.get(buffer, 3 * vectorIndex, vector);
        String locString = MyVector3f.describe(vector);
        return locString;
    }

    private void dumpChildren(CompoundCollisionShape parent, String indent) {
        ChildCollisionShape[] children;
        PhysicsDescriber describer = this.getDescriber();
        for (ChildCollisionShape child : children = parent.listChildren()) {
            Quaternion rot;
            this.addLine(indent);
            CollisionShape baseShape = child.getShape();
            String desc = describer.describe(baseShape);
            this.stream.print(desc);
            Vector3f offset = child.copyOffset(null);
            if (!MyVector3f.isZero(offset)) {
                this.stream.print(" offset[");
                desc = MyVector3f.describe(offset);
                this.stream.print(desc);
                this.stream.print(']');
            }
            if (!MyQuaternion.isRotationIdentity(rot = child.copyRotation(null))) {
                this.stream.print(" rot[");
                desc = MyQuaternion.describe(rot);
                this.stream.print(desc);
                this.stream.print(']');
            }
            Vector3f scale = baseShape.getScale(null);
            desc = describer.describeScale(scale);
            this.addDescription(desc);
            long objectId = baseShape.nativeId();
            this.addNativeId(objectId);
        }
    }

    private void dumpClusters(PhysicsSoftBody softBody, String indent) {
        this.stream.print(':');
        FloatBuffer coms = softBody.copyClusterCenters(null);
        FloatBuffer masses = softBody.copyClusterMasses(null);
        int numClusters = softBody.countClusters();
        for (int clusterIndex = 0; clusterIndex < numClusters; ++clusterIndex) {
            this.stream.printf("%n%s  [%d] com[", indent, clusterIndex);
            String desc = PhysicsDumper.describeVector(coms, clusterIndex);
            this.stream.print(desc);
            this.stream.print("] mass=");
            float mass = masses.get(clusterIndex);
            this.stream.print(MyString.describe(mass));
            this.stream.print(" damp[ang=");
            float angularDamping = softBody.get(Cluster.AngularDamping, clusterIndex);
            this.stream.print(MyString.describe(angularDamping));
            this.stream.print(" lin=");
            float linearDamping = softBody.get(Cluster.LinearDamping, clusterIndex);
            this.stream.print(MyString.describe(linearDamping));
            this.stream.print(" node=");
            float nodeDamping = softBody.get(Cluster.NodeDamping, clusterIndex);
            this.stream.print(MyString.describe(nodeDamping));
            this.stream.print("] match=");
            float matching = softBody.get(Cluster.Matching, clusterIndex);
            this.stream.print(MyString.describe(matching));
            this.stream.print(" scif=");
            float selfImpulse = softBody.get(Cluster.SelfImpulse, clusterIndex);
            this.stream.print(MyString.describe(selfImpulse));
            this.stream.print(" maxSci=");
            float maxSelfImpulse = softBody.get(Cluster.MaxSelfImpulse, clusterIndex);
            this.stream.print(MyString.describe(maxSelfImpulse));
            int numNodes = softBody.countNodesInCluster(clusterIndex);
            this.stream.printf("  %d node%s", numNodes, numNodes == 1 ? "" : "s");
            if (!this.dumpMotors) continue;
            this.dumpNodesInCluster(softBody, clusterIndex);
        }
        this.addLine(indent);
    }

    private void dumpIgnores(PhysicsCollisionObject pco, String indent) {
        this.stream.print(':');
        PhysicsCollisionObject[] ignoreList = pco.listIgnoredPcos();
        String moreIndent = indent + this.indentIncrement();
        for (PhysicsCollisionObject otherPco : ignoreList) {
            this.addLine(moreIndent);
            PhysicsDescriber describer = this.getDescriber();
            String desc = describer.describePco(otherPco, this.dumpNativeIDs);
            this.stream.print(desc);
        }
        this.addLine(indent);
    }

    private void dumpJoints(Collection<? extends PhysicsJoint> joints, String indent) {
        for (PhysicsJoint physicsJoint : joints) {
            this.dump(physicsJoint, indent);
        }
    }

    private void dumpJoints(PhysicsBody body, String indent) {
        this.stream.print(':');
        PhysicsJoint[] joints = body.listJoints();
        PhysicsDescriber describer = this.getDescriber();
        String moreIndent = indent + this.indentIncrement();
        for (PhysicsJoint joint : joints) {
            String desc = describer.describeJointInBody(joint, body, this.dumpNativeIDs);
            this.stream.printf("%n%s%s", moreIndent, desc);
        }
    }

    private void dumpLink(MultiBodyLink link, String indent) {
        this.addLine(indent);
        int index = link.index();
        MultiBodyJointType jointType = link.jointType();
        this.stream.printf("Link[%d] %s->", new Object[]{index, jointType});
        MultiBodyLink parent = link.getParentLink();
        if (parent == null) {
            this.stream.print("base");
        } else {
            int parentIndex = parent.index();
            this.stream.print(parentIndex);
        }
        long objectId = link.nativeId();
        this.addNativeId(objectId);
        MultiBodyCollider collider = link.getCollider();
        if (collider != null) {
            this.dump(collider, indent + this.indentIncrement());
        }
    }

    private void dumpMultiBody(MultiBody multibody, String indent) {
        this.addLine(indent);
        this.stream.print("MultiBody");
        PhysicsDescriber describer = this.getDescriber();
        String desc = describer.describeGroups(multibody);
        this.stream.print(desc);
        if (multibody.hasFixedBase()) {
            this.stream.print("/fixed");
        }
        if (!multibody.isUsingGyroTerm()) {
            this.stream.print("/NOgyro");
        }
        if (!multibody.canSleep()) {
            this.stream.print("/NOsleep");
        }
        if (multibody.isUsingRK4()) {
            this.stream.print("/RK4");
        }
        int numColliders = multibody.listColliders().size();
        int numLinks = multibody.countConfiguredLinks();
        this.stream.printf(" with %d collider%s, %d link%s", numColliders, numColliders == 1 ? "" : "s", numLinks, numLinks == 1 ? "" : "s");
        long objectId = multibody.nativeId();
        this.addNativeId(objectId);
        this.addLine(indent);
        float angularDamping = multibody.angularDamping();
        float linearDamping = multibody.linearDamping();
        this.stream.print(" damp[l=");
        this.stream.print(MyString.describe(linearDamping));
        this.stream.print(" a=");
        this.stream.print(MyString.describe(angularDamping));
        this.stream.print(']');
        float maxImp = multibody.maxAppliedImpulse();
        float maxV = multibody.maxCoordinateVelocity();
        this.stream.print(" max[imp=");
        this.stream.print(MyString.describe(maxImp));
        this.stream.print(" v=");
        this.stream.print(MyString.describe(maxV));
        this.stream.print(']');
        String moreIndent = indent + this.indentIncrement();
        MultiBodyCollider collider = multibody.getBaseCollider();
        if (collider != null) {
            this.dump(collider, moreIndent);
        }
        for (int linkIndex = 0; linkIndex < numLinks; ++linkIndex) {
            MultiBodyLink link = multibody.getLink(linkIndex);
            this.dumpLink(link, moreIndent);
        }
    }

    private void dumpNodes(PhysicsSoftBody softBody, String indent) {
        this.stream.print(':');
        FloatBuffer locations = softBody.copyLocations(null);
        FloatBuffer masses = softBody.copyMasses(null);
        FloatBuffer velocities = softBody.copyVelocities(null);
        IntBuffer linkIndices = softBody.copyLinks(null);
        int numNodes = softBody.countNodes();
        int numLinks = softBody.countLinks();
        for (int nodeIndex = 0; nodeIndex < numNodes; ++nodeIndex) {
            int degree = MyBuffer.frequency(linkIndices, 0, 2 * numLinks, nodeIndex);
            float nodeMass = masses.get(nodeIndex);
            String locString = PhysicsDumper.describeVector(locations, nodeIndex);
            String vString = PhysicsDumper.describeVector(velocities, nodeIndex);
            this.stream.printf("%n%s  [%d] deg=%d mass=%s loc[%s] v[%s]", indent, nodeIndex, degree, MyString.describe(nodeMass), locString, vString);
        }
    }

    private void dumpNodesInCluster(PhysicsSoftBody softBody, int clusterIndex) {
        int nodeIndex;
        int numNodesInBody;
        IntBuffer nodeIndices = softBody.listNodesInCluster(clusterIndex, null);
        int numIndices = nodeIndices.capacity();
        if (numIndices == (numNodesInBody = softBody.countNodes())) {
            this.stream.print("(all)");
            return;
        }
        BitSet bitSet = new BitSet(numNodesInBody);
        for (int i = 0; i < numIndices; ++i) {
            nodeIndex = nodeIndices.get(i);
            bitSet.set(nodeIndex);
        }
        this.stream.print('(');
        boolean addSeparators = false;
        for (nodeIndex = 0; nodeIndex < numNodesInBody; ++nodeIndex) {
            if (!bitSet.get(nodeIndex)) continue;
            if (addSeparators) {
                this.stream.print(',');
            } else {
                addSeparators = true;
            }
            int runLength = bitSet.nextClearBit(nodeIndex) - nodeIndex;
            if (runLength < 3) {
                this.stream.printf("%d", nodeIndex);
                continue;
            }
            int endIndex = nodeIndex + runLength - 1;
            this.stream.printf("%d-%d", nodeIndex, endIndex);
            nodeIndex = endIndex;
        }
        this.stream.print(')');
    }

    private void dumpWheels(PhysicsVehicle vehicle, String indent, int numWheels) {
        this.stream.print(':');
        PhysicsDescriber describer = this.getDescriber();
        String moreIndent = indent + this.indentIncrement();
        for (int wheelIndex = 0; wheelIndex < numWheels; ++wheelIndex) {
            this.stream.printf("%n%s[%d] ", moreIndent, wheelIndex);
            VehicleWheel wheel = vehicle.getWheel(wheelIndex);
            String desc = describer.describe(wheel);
            this.stream.print(desc);
            this.stream.printf("%n%s ", moreIndent);
            desc = describer.describe2(wheel);
            this.stream.print(desc);
            this.stream.print(" raycast=");
            float raycast = vehicle.castRay(wheelIndex);
            this.stream.print(MyString.describe(raycast));
            if (!(raycast >= 0.0f)) continue;
            this.stream.print(" skid=");
            float skid = wheel.getSkidInfo();
            this.stream.print(MyString.describe(skid));
        }
        this.addLine(indent);
    }
}

