/*
 * Decompiled with CFR 0.152.
 */
package ru.nsk.kstatemachine.visitors;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.nsk.kstatemachine.event.Event;
import ru.nsk.kstatemachine.state.IState;
import ru.nsk.kstatemachine.statemachine.StateMachine;
import ru.nsk.kstatemachine.transition.Transition;
import ru.nsk.kstatemachine.visitors.RecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0016J \u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\bH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/nsk/kstatemachine/visitors/RequireNonBlankNamesVisitor;", "Lru/nsk/kstatemachine/visitors/RecursiveVisitor;", "<init>", "()V", "invalidStates", "", "Lru/nsk/kstatemachine/state/IState;", "invalidTransitions", "Lru/nsk/kstatemachine/transition/Transition;", "visit", "", "machine", "Lru/nsk/kstatemachine/statemachine/StateMachine;", "state", "E", "Lru/nsk/kstatemachine/event/Event;", "transition", "hasBlankNames", "", "checkNonBlankNames", "SparkCore-1.21.1-neoforge"})
public final class RequireNonBlankNamesVisitor
implements RecursiveVisitor {
    @NotNull
    private final Set<IState> invalidStates = new LinkedHashSet();
    @NotNull
    private final Set<Transition<?>> invalidTransitions = new LinkedHashSet();

    @Override
    public void visit(@NotNull StateMachine machine2) {
        Intrinsics.checkNotNullParameter((Object)machine2, (String)"machine");
        CharSequence charSequence = machine2.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidStates).add(machine2);
        }
        this.visitChildren(machine2);
    }

    @Override
    public void visit(@NotNull IState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        CharSequence charSequence = state2.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidStates).add(state2);
        }
        if (!(state2 instanceof StateMachine)) {
            this.visitChildren(state2);
        }
    }

    @Override
    public <E extends Event> void visit(@NotNull Transition<E> transition2) {
        Intrinsics.checkNotNullParameter(transition2, (String)"transition");
        CharSequence charSequence = transition2.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ((Collection)this.invalidTransitions).add(transition2);
        }
    }

    public final boolean hasBlankNames() {
        return !((Collection)this.invalidStates).isEmpty() || !((Collection)this.invalidTransitions).isEmpty();
    }

    public final void checkNonBlankNames() {
        if (!(!this.hasBlankNames())) {
            boolean bl = false;
            String statesText = CollectionsKt.joinToString$default((Iterable)this.invalidStates, null, null, null, (int)0, null, RequireNonBlankNamesVisitor::checkNonBlankNames$lambda$2$lambda$0, (int)31, null);
            String transitionsText = CollectionsKt.joinToString$default((Iterable)this.invalidTransitions, null, null, null, (int)0, null, RequireNonBlankNamesVisitor::checkNonBlankNames$lambda$2$lambda$1, (int)31, null);
            String string = "There were blank names in states: " + statesText + " transitions: " + transitionsText;
            throw new IllegalStateException(string.toString());
        }
    }

    private static final CharSequence checkNonBlankNames$lambda$2$lambda$0(IState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + " (child of " + it.getParent() + ")";
    }

    private static final CharSequence checkNonBlankNames$lambda$2$lambda$1(Transition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + " (in " + it.getSourceState() + ")";
    }
}

