/*
 * Decompiled with CFR 0.152.
 */
package com.ttttdoy.bacillus.block;

import com.mojang.serialization.MapCodec;
import com.ttttdoy.bacillus.block.BacteriaBlock;
import com.ttttdoy.bacillus.block.entity.BacteriaBlockEntity;
import com.ttttdoy.bacillus.registry.ModBlockEntityTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0014J8\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0016J'\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010!J8\u0010\"\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0014H\u0014J0\u0010&\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0014H\u0014J\u0010\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005H\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\rH\u0014J\b\u0010+\u001a\u00020\u0014H\u0016J(\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0014J(\u00100\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lcom/ttttdoy/bacillus/block/BacteriaBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "newBlockEntity", "Lcom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "propagatesSkylightDown", "", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/Level;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "start", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lkotlin/Unit;", "neighborChanged", "block", "neighborPos", "moved", "onPlace", "oldState", "movedByPiston", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "hasDynamicShape", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getCollisionShape", "bacillus-common"})
public final class BacteriaBlock
extends BaseEntityBlock {
    @NotNull
    private final MapCodec<BacteriaBlock> codec;

    public BacteriaBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.SPONGE)).instabreak().noOcclusion());
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(arg_0 -> BacteriaBlock.codec$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        this.codec = mapCodec;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public final MapCodec<BacteriaBlock> getCodec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.ENABLED, BlockStateProperties.TRIGGERED};
        builder.add(propertyArray);
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    public BacteriaBlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return new BacteriaBlockEntity(blockPos, blockState);
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        return level instanceof ServerLevel ? BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getBACTERIA_BLOCK_ENTITY().get()), (BlockEntityTicker)getTicker.1.INSTANCE) : null;
    }

    private final Unit start(Level level, BlockPos blockPos, BlockState blockState) {
        Unit unit;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity != null) {
            BlockEntity entity = blockEntity;
            boolean bl = false;
            if (entity instanceof BacteriaBlockEntity && ((BacteriaBlockEntity)entity).getIO(level)) {
                ((BacteriaBlockEntity)entity).setActive(500);
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)), 2);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    protected void neighborChanged(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        if (!level.hasNeighborSignal(blockPos)) {
            return;
        }
        this.start(level, blockPos, blockState);
    }

    protected void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        if (!level.hasNeighborSignal(pos)) {
            return;
        }
        this.start(level, pos, blockState);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return (Boolean)blockState.getValue((Property)BlockStateProperties.TRIGGERED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public boolean hasDynamicShape() {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BacteriaBlockEntity bacteriaBlockEntity = blockEntity instanceof BacteriaBlockEntity ? (BacteriaBlockEntity)blockEntity : null;
        if (bacteriaBlockEntity == null) {
            VoxelShape voxelShape = Shapes.block();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
            return voxelShape;
        }
        BacteriaBlockEntity entity = bacteriaBlockEntity;
        BlockState blockState = entity.getConsumedBlockState();
        if (blockState == null || (blockState = blockState.getVisualShape(level, pos, context)) == null) {
            VoxelShape voxelShape = Shapes.block();
            blockState = voxelShape;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
        }
        return blockState;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BacteriaBlockEntity bacteriaBlockEntity = blockEntity instanceof BacteriaBlockEntity ? (BacteriaBlockEntity)blockEntity : null;
        if (bacteriaBlockEntity == null) {
            VoxelShape voxelShape = Shapes.block();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
            return voxelShape;
        }
        BacteriaBlockEntity entity = bacteriaBlockEntity;
        BlockState blockState = entity.getConsumedBlockState();
        if (blockState == null || (blockState = blockState.getCollisionShape(level, pos, context)) == null) {
            VoxelShape voxelShape = Shapes.block();
            blockState = voxelShape;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
        }
        return blockState;
    }

    private static final BacteriaBlock codec$lambda$0(BacteriaBlock this$0, BlockBehaviour.Properties it) {
        return this$0;
    }
}

