/*
 * Decompiled with CFR 0.152.
 */
package com.ttttdoy.bacillus.block.entity;

import com.ttttdoy.bacillus.registry.ModBlockEntityTypes;
import com.ttttdoy.bacillus.registry.ModBlockTags;
import com.ttttdoy.bacillus.registry.ModBlocks;
import com.ttttdoy.bacillus.util.General;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.SimplexNoise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001aH\u0014J\u0018\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001aH\u0014J\u0018\u00105\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0003H\u0002J\u0016\u00107\u001a\u00020-2\u0006\u0010\u0012\u001a\u0002082\u0006\u00106\u001a\u00020\u0003R0\u0010\b\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010 R\u001a\u0010)\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010 R\u001b\u00101\u001a\n 2*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u00104\u001a\u0004\b3\u0010#\u00a8\u0006:"}, d2={"Lcom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "cached", "Lkotlin/Pair;", "", "Lnet/minecraft/world/level/block/Block;", "getCached", "()Lkotlin/Pair;", "setCached", "(Lkotlin/Pair;)V", "getIO", "", "level", "Lnet/minecraft/world/level/Level;", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "active", "", "getActive", "()I", "setActive", "(I)V", "consumedBlockState", "getConsumedBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "setConsumedBlockState", "(Lnet/minecraft/world/level/block/state/BlockState;)V", "tickChance", "getTickChance", "setTickChance", "grace", "getGrace", "setGrace", "saveAdditional", "", "compoundTag", "provider", "loadAdditional", "germinationState", "kotlin.jvm.PlatformType", "getGerminationState", "Lnet/minecraft/world/level/block/state/BlockState;", "replace", "pos", "tick", "Lnet/minecraft/server/level/ServerLevel;", "Companion", "bacillus-common"})
@SourceDebugExtension(value={"SMAP\nBacteriaBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BacteriaBlockEntity.kt\ncom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n1557#3:185\n1628#3,3:186\n*S KotlinDebug\n*F\n+ 1 BacteriaBlockEntity.kt\ncom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity\n*L\n123#1:185\n123#1:186,3\n*E\n"})
public final class BacteriaBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Pair<? extends Set<? extends Block>, ? extends Block> cached;
    private int active;
    @Nullable
    private BlockState consumedBlockState;
    private int tickChance;
    private int grace;
    private final BlockState germinationState;
    private static boolean globalJamState;
    private static boolean globalKillState;

    public BacteriaBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getBACTERIA_BLOCK_ENTITY().get(), blockPos, blockState);
        this.active = -1;
        this.tickChance = 80;
        this.grace = 1;
        this.germinationState = (BlockState)(Intrinsics.areEqual((Object)blockState.getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getDESTROYER().get()).getBlock()) ? ((BlockItem)ModBlocks.INSTANCE.getDESTROYER().get()).getBlock().defaultBlockState() : ((BlockItem)ModBlocks.INSTANCE.getREPLACER().get()).getBlock().defaultBlockState()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true));
    }

    @Nullable
    public final Pair<Set<Block>, Block> getCached() {
        return this.cached;
    }

    public final void setCached(@Nullable Pair<? extends Set<? extends Block>, ? extends Block> pair) {
        this.cached = pair;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getIO(@NotNull Level level) {
        Collection collection;
        Block block;
        BlockState state;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.cached != null) {
            return false;
        }
        List input = new ArrayList();
        BlockPos position = this.getBlockPos().below();
        while (!(state = level.getBlockState(position)).isAir()) {
            if (!state.is(ModBlockTags.INSTANCE.getUNFILTERABLE()) && !Intrinsics.areEqual((Object)position, (Object)this.getBlockPos()) && Intrinsics.areEqual((Object)this.getBlockState().getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getDESTROYER().get()).getBlock()) && !state.is(ModBlockTags.INSTANCE.getUNREMOVABLE()) || Intrinsics.areEqual((Object)this.getBlockState().getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getREPLACER().get()).getBlock()) && !state.is(ModBlockTags.INSTANCE.getUNREPLACEABLE())) {
                if (Intrinsics.areEqual((Object)state.getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getEVERYTHING().get()).getBlock())) {
                    input = null;
                    break;
                }
                Block block2 = state.getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"getBlock(...)");
                input.add(block2);
            }
            position = position.above();
        }
        if (Intrinsics.areEqual((Object)this.getBlockState().getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getREPLACER().get()).getBlock())) {
            BlockState above = level.getBlockState(this.getBlockPos().above());
            if (above.isAir() || Intrinsics.areEqual((Object)above, (Object)this.getBlockState().getBlock())) {
                return false;
            }
            Block block3 = above.getBlock();
            Intrinsics.checkNotNull((Object)block3);
            block = block3;
        } else {
            Block block4 = Blocks.AIR;
            block = block4;
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"AIR");
        }
        Block output = block;
        BacteriaBlockEntity bacteriaBlockEntity = this;
        Collection collection2 = input;
        if (collection2 != null && (collection2 = CollectionsKt.toMutableSet((Iterable)collection2)) != null) {
            void it;
            Collection collection3;
            Collection collection4 = collection3 = collection2;
            BacteriaBlockEntity bacteriaBlockEntity2 = bacteriaBlockEntity;
            boolean bl = false;
            it.remove(output);
            bacteriaBlockEntity = bacteriaBlockEntity2;
            collection = collection3;
        } else {
            collection = null;
        }
        bacteriaBlockEntity.cached = TuplesKt.to(collection, (Object)output);
        return true;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag it = compoundTag = super.getUpdateTag(registries);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.saveAdditional(it, registries);
        CompoundTag compoundTag2 = compoundTag;
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"also(...)");
        return compoundTag2;
    }

    public final int getActive() {
        return this.active;
    }

    public final void setActive(int n) {
        this.active = n;
    }

    @Nullable
    public final BlockState getConsumedBlockState() {
        return this.consumedBlockState;
    }

    public final void setConsumedBlockState(@Nullable BlockState blockState) {
        this.consumedBlockState = blockState;
    }

    public final int getTickChance() {
        return this.tickChance;
    }

    public final void setTickChance(int n) {
        this.tickChance = n;
    }

    public final int getGrace() {
        return this.grace;
    }

    public final void setGrace(int n) {
        this.grace = n;
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        block3: {
            Pair<? extends Set<? extends Block>, ? extends Block> it;
            block4: {
                Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                Pair<? extends Set<? extends Block>, ? extends Block> pair = this.cached;
                if (pair == null) break block3;
                it = pair;
                boolean bl = false;
                if (it.getFirst() == null) break block4;
                Set set = (Set)it.getFirst();
                if (set == null) break block3;
                compoundTag.putString("inputs", CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"#", null, null, (int)0, null, BacteriaBlockEntity::saveAdditional$lambda$3$lambda$2, (int)30, null));
            }
            compoundTag.putString("outputs", BuiltInRegistries.BLOCK.getKey(it.getSecond()).toString());
        }
        compoundTag.putInt("active", this.active);
        compoundTag.putInt("grace", this.grace);
        if (this.consumedBlockState != null) {
            CompoundTag compoundTag2;
            CompoundTag it = compoundTag2 = new CompoundTag();
            boolean bl = false;
            BlockState blockState = this.consumedBlockState;
            if (blockState != null) {
                General.INSTANCE.serializeInto(blockState, it);
                compoundTag.put("consumedBlockState", (Tag)it);
            }
        }
        super.saveAdditional(compoundTag, provider);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        String string = compoundTag.getString("inputs");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Object object = new String[]{"#"};
        object = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)it)));
        }
        Set input = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object object2 = BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)compoundTag.getString("outputs")));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Block output = (Block)object2;
        this.cached = TuplesKt.to((Object)input, (Object)output);
        this.active = compoundTag.getInt("active");
        this.grace = compoundTag.getInt("grace");
        if (compoundTag.contains("consumedBlockState")) {
            CompoundTag compoundTag2 = compoundTag.getCompound("consumedBlockState");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"getCompound(...)");
            this.consumedBlockState = General.INSTANCE.deserializeBlockState(compoundTag2);
        }
        super.loadAdditional(compoundTag, provider);
    }

    public final BlockState getGerminationState() {
        return this.germinationState;
    }

    private final void replace(Level level, BlockPos pos) {
        VoxelShape shape;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            BlockEntity p0 = blockEntity;
            boolean $i$f$replace$stub_for_inlining = false;
            boolean bl = false;
            Clearable.tryClear((Object)p0);
        }
        BlockState blockState = this.germinationState;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"germinationState");
        BacteriaBlockEntity newBacteria = new BacteriaBlockEntity(pos, blockState);
        BlockState consumeBlockState = level.getBlockState(pos);
        if (consumeBlockState.getRenderShape() == RenderShape.MODEL && !Intrinsics.areEqual((Object)(shape = consumeBlockState.getShape((BlockGetter)level, pos)), (Object)Shapes.block()) && !Intrinsics.areEqual((Object)shape, (Object)Shapes.empty())) {
            newBacteria.consumedBlockState = consumeBlockState;
        }
        newBacteria.cached = this.cached;
        int n = this.active;
        this.active = n + -1;
        newBacteria.active = n;
        newBacteria.tickChance = MathKt.roundToInt((float)((float)newBacteria.tickChance * Math.max(1.0f, 1.0f + SimplexNoise.noise((float)((float)((double)pos.getX() * 0.1)), (float)((float)((double)pos.getY() * 0.1)), (float)((float)((double)pos.getZ() * 0.1))))));
        level.setBlock(pos, (BlockState)this.germinationState.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(newBacteria.consumedBlockState != null)), 2);
        level.setBlockEntity((BlockEntity)newBacteria);
        level.playSound(null, pos, SoundEvents.CHORUS_FLOWER_GROW, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    public final void tick(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Pair<? extends Set<? extends Block>, ? extends Block> pair = this.cached;
        if (pair == null) {
            return;
        }
        Pair<? extends Set<? extends Block>, ? extends Block> cache = pair;
        if ((this.active == -1 || globalJamState) && !globalKillState) {
            return;
        }
        if (globalKillState || this.grace < 0 || this.active == 0) {
            level.setBlock(pos, ((Block)cache.getSecond()).defaultBlockState(), 2);
            this.setRemoved();
        } else {
            if (level.random.nextInt(this.tickChance) != 0) {
                return;
            }
            Level level2 = (Level)level;
            Block block = this.getBlockState().getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            BlockPos blockPos2 = General.INSTANCE.getNextPositionFiltered(level2, block, blockPos, (Set)cache.getFirst(), (Block)cache.getSecond());
            if (blockPos2 != null) {
                BlockPos it = blockPos2;
                boolean bl = false;
                this.replace((Level)level, it);
            }
            int n = this.grace;
            this.grace = n + -1;
        }
    }

    private static final CharSequence saveAdditional$lambda$3$lambda$2(Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity$Companion;", "", "<init>", "()V", "globalJamState", "", "getGlobalJamState", "()Z", "setGlobalJamState", "(Z)V", "globalKillState", "getGlobalKillState", "setGlobalKillState", "bacillus-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getGlobalJamState() {
            return globalJamState;
        }

        public final void setGlobalJamState(boolean bl) {
            globalJamState = bl;
        }

        public final boolean getGlobalKillState() {
            return globalKillState;
        }

        public final void setGlobalKillState(boolean bl) {
            globalKillState = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

