/*
 * Decompiled with CFR 0.152.
 */
package com.ttttdoy.bacillus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ttttdoy.bacillus.Bacillus;
import com.ttttdoy.bacillus.block.entity.BacteriaBlockEntity;
import com.ttttdoy.bacillus.registry.ModBlocks;
import com.ttttdoy.bacillus.registry.ModRenderType;
import java.awt.Color;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016JH\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/ttttdoy/bacillus/client/render/BacteriaBlockRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/ttttdoy/bacillus/block/entity/BacteriaBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "instance", "Lnet/minecraft/client/Minecraft;", "debugMode", "", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "renderText", "text", "", "x", "", "y", "z", "color", "bgColor", "bacillus-common"})
@SourceDebugExtension(value={"SMAP\nBacteriaBlockRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BacteriaBlockRenderer.kt\ncom/ttttdoy/bacillus/client/render/BacteriaBlockRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n*S KotlinDebug\n*F\n+ 1 BacteriaBlockRenderer.kt\ncom/ttttdoy/bacillus/client/render/BacteriaBlockRenderer\n*L\n92#1:138,2\n*E\n"})
public final class BacteriaBlockRenderer
implements BlockEntityRenderer<BacteriaBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    @NotNull
    private final Minecraft instance;
    private final boolean debugMode;

    public BacteriaBlockRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
        this.instance = minecraft;
    }

    public void render(@NotNull BacteriaBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState it;
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.TRIGGERED)).booleanValue()) {
            return;
        }
        String[] stringArray = new String[]{"textures/block/" + (Intrinsics.areEqual((Object)blockEntity.getBlockState().getBlock(), (Object)((BlockItem)ModBlocks.INSTANCE.getDESTROYER().get()).getBlock()) ? "destroyer" : "replacer") + ".png"};
        ResourceLocation texture = Bacillus.modLocation$default(Bacillus.INSTANCE, stringArray, false, 2, null);
        BlockState blockState = blockEntity.getConsumedBlockState();
        if (blockState != null) {
            it = blockState;
            boolean bl = false;
            this.context.getBlockRenderDispatcher().getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(ModRenderType.INSTANCE.solidTextured(texture)), it, this.instance.getModelManager().getBlockModelShaper().getBlockModel(it), 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
        if (!this.debugMode) {
            return;
        }
        this.renderText("active: " + blockEntity.getActive(), 0.5, 1.5, 0.5, Color.WHITE.getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB(), poseStack, bufferSource);
        this.renderText("grace: " + blockEntity.getGrace(), 0.5, 1.8, 0.5, Color.WHITE.getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB(), poseStack, bufferSource);
        Pair<Set<Block>, Block> pair = blockEntity.getCached();
        this.renderText("output: " + (Block)(pair != null ? (Block)pair.getSecond() : null), 0.5, 2.0, 0.5, Color.WHITE.getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB(), poseStack, bufferSource);
        BlockState blockState2 = blockEntity.getConsumedBlockState();
        if (blockState2 != null) {
            it = blockState2;
            boolean bl = false;
            this.renderText("consumedBlockState: " + it, 0.5, 2.3, 0.5, Color.WHITE.getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB(), poseStack, bufferSource);
        }
        double pos = 0.0;
        pos = 2.6;
        Object object = blockEntity.getCached();
        if (object != null && (object = (Set)object.getFirst()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block block = (Block)element$iv;
                boolean bl = false;
                this.renderText("input: " + block, 0.5, pos, 0.5, Color.WHITE.getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.5f).getRGB(), poseStack, bufferSource);
                pos += 0.2;
            }
        }
        pos = 2.2;
    }

    private final void renderText(String text, double x, double y, double z, int color, int bgColor, PoseStack poseStack, MultiBufferSource bufferSource) {
        LocalPlayer localPlayer = this.instance.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees(-player.yHeadRot));
        poseStack.mulPose(Axis.XN.rotationDegrees(player.getXRot()));
        poseStack.scale(0.02f, 0.02f, 0.02f);
        this.context.getFont().drawInBatch(text, (float)(-this.context.getFont().width(text)) / 2.0f, 0.0f, color, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, bgColor, 0xF000F0);
        poseStack.popPose();
    }
}

