/*
 * Decompiled with CFR 0.152.
 */
package com.ttttdoy.bacillus.item;

import com.ttttdoy.bacillus.Bacillus;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016R\u001b\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/ttttdoy/bacillus/item/DestroyerItem;", "Lnet/minecraft/world/item/BlockItem;", "block", "Lnet/minecraft/world/level/block/Block;", "<init>", "(Lnet/minecraft/world/level/block/Block;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "Lorg/apache/logging/log4j/Logger;", "overrideOtherStackedOnMe", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "other", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "overrideStackedOnOther", "playTrashSound", "", "appendHoverText", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "bacillus-common"})
public final class DestroyerItem
extends BlockItem {
    private final Logger logger;

    public DestroyerItem(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super(block, new Item.Properties());
        this.logger = LogManager.getLogger();
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (action == ClickAction.SECONDARY && slot.allowModification(player) && !other.isEmpty()) {
            this.logger.info((Object)other);
            other.shrink(other.getCount());
            this.playTrashSound(player);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack item = slot.getItem();
        if (action == ClickAction.SECONDARY && !item.isEmpty()) {
            item.shrink(item.getCount());
            this.playTrashSound(player);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void playTrashSound(Player player) {
        if (player.level().isClientSide) {
            Minecraft instance = Minecraft.getInstance();
            LocalPlayer localPlayer = instance.player;
            if (localPlayer == null) {
                return;
            }
            localPlayer.playSound(SoundEvents.CHORUS_FLOWER_GROW, 1.0f, 1.0f);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Object[] objectArray = new MutableComponent[3];
        String[] stringArray = new String[]{"destroyer", "tooltip_1"};
        objectArray[0] = Bacillus.modTranslatable$default(Bacillus.INSTANCE, "item", stringArray, null, 4, null).withStyle(ChatFormatting.GOLD);
        stringArray = new String[]{"destroyer", "tooltip_2"};
        objectArray[1] = Bacillus.modTranslatable$default(Bacillus.INSTANCE, "item", stringArray, null, 4, null);
        stringArray = new String[]{"destroyer", "tooltip_3"};
        objectArray[2] = Bacillus.modTranslatable$default(Bacillus.INSTANCE, "item", stringArray, null, 4, null);
        tooltipComponents.addAll(CollectionsKt.listOf((Object[])objectArray));
    }
}

