/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nature.init;

import net.mcreator.nature.entity.DJTEntity;
import net.mcreator.nature.entity.GunpEntity;
import net.mcreator.nature.entity.LandsharkEntity;
import net.mcreator.nature.entity.LandsharkEntityProjectile;
import net.mcreator.nature.entity.LandwhaleEntity;
import net.mcreator.nature.entity.SFAEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class NaturePlusModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"nature_plus");
    public static final DeferredHolder<EntityType<?>, EntityType<LandwhaleEntity>> LANDWHALE = NaturePlusModEntities.register("landwhale", EntityType.Builder.of(LandwhaleEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<LandsharkEntity>> LANDSHARK = NaturePlusModEntities.register("landshark", EntityType.Builder.of(LandsharkEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<LandsharkEntityProjectile>> LANDSHARK_PROJECTILE = NaturePlusModEntities.register("projectile_landshark", EntityType.Builder.of(LandsharkEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<GunpEntity>> GUNP = NaturePlusModEntities.register("gunp", EntityType.Builder.of(GunpEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.1f, 0.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<DJTEntity>> DJT = NaturePlusModEntities.register("djt", EntityType.Builder.of(DJTEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SFAEntity>> SFA = NaturePlusModEntities.register("sfa", EntityType.Builder.of(SFAEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(SpawnPlacementRegisterEvent event) {
        LandwhaleEntity.init(event);
        LandsharkEntity.init(event);
        DJTEntity.init(event);
        SFAEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)LANDWHALE.get(), LandwhaleEntity.createAttributes().build());
        event.put((EntityType)LANDSHARK.get(), LandsharkEntity.createAttributes().build());
        event.put((EntityType)DJT.get(), DJTEntity.createAttributes().build());
        event.put((EntityType)SFA.get(), SFAEntity.createAttributes().build());
    }
}

