/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nature.fluid;

import net.mcreator.nature.init.NaturePlusModBlocks;
import net.mcreator.nature.init.NaturePlusModFluidTypes;
import net.mcreator.nature.init.NaturePlusModFluids;
import net.mcreator.nature.init.NaturePlusModItems;
import net.mcreator.nature.init.NaturePlusModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class OilFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)NaturePlusModFluidTypes.OIL_TYPE.get(), () -> (Fluid)NaturePlusModFluids.OIL.get(), () -> (Fluid)NaturePlusModFluids.FLOWING_OIL.get()).explosionResistance(100.0f).tickRate(60).levelDecreasePerBlock(3).bucket(() -> (Item)NaturePlusModItems.OIL_BUCKET.get()).block(() -> (LiquidBlock)NaturePlusModBlocks.OIL.get());

    private OilFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)NaturePlusModParticleTypes.OILDRIPPING.get();
    }

    public static class Flowing
    extends OilFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends OilFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

