/*
 * Decompiled with CFR 0.152.
 */
package cn.flowerinsnow.hidearmour.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ObjectNode;

@Environment(value=EnvType.CLIENT)
public class HideArmourConfig {
    private ObjectNode root;
    private static final JsonMapper JSON_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS, JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, JsonReadFeature.ALLOW_SINGLE_QUOTES, JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES}).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).disable(new JsonWriteFeature[]{JsonWriteFeature.QUOTE_PROPERTY_NAMES}).build();
    private static final String FIELD_NAME_VERSION = "version";
    private static final int VERSION = 2;
    private static final String FIELD_NAME_ENABLE = "enable";
    private static final String FIELD_NAME_HEAD = "head";
    private static final String FIELD_NAME_HEAD_HELMET = "helmet";
    private static final String FIELD_NAME_HEAD_SKULL = "skull";
    private static final String FIELD_NAME_HEAD_BLOCK = "block";
    private static final String FIELD_NAME_CHEST = "chest";
    private static final String FIELD_NAME_CHEST_CHESTPLATE = "chestplate";
    private static final String FIELD_NAME_CHEST_ELYTRA = "elytra";
    private static final String FIELD_NAME_LEGGINGS = "leggings";
    private static final String FIELD_NAME_BOOTS = "boots";

    private HideArmourConfig() {
    }

    @Contract(value="-> new")
    public static HideArmourConfig create() {
        return new HideArmourConfig();
    }

    @Contract(value="-> new", pure=true)
    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hide-armour.json5");
    }

    @Contract(mutates="io,this")
    public void init() {
        try {
            Files.deleteIfExists(FabricLoader.getInstance().getConfigDir().resolve("hide-armour.toml"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path configPath = HideArmourConfig.getConfigPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.root = JSON_MAPPER.createObjectNode();
            this.root.put(FIELD_NAME_VERSION, 2);
            this.root.put(FIELD_NAME_ENABLE, true);
            ObjectNode headNode = JSON_MAPPER.createObjectNode();
            headNode.put(FIELD_NAME_HEAD_HELMET, true);
            headNode.put(FIELD_NAME_HEAD_SKULL, true);
            headNode.put(FIELD_NAME_HEAD_BLOCK, true);
            this.root.set(FIELD_NAME_HEAD, (JsonNode)headNode);
            ObjectNode chestNode = JSON_MAPPER.createObjectNode();
            chestNode.put(FIELD_NAME_CHEST_CHESTPLATE, true);
            chestNode.put(FIELD_NAME_CHEST_ELYTRA, true);
            this.root.set(FIELD_NAME_CHEST, (JsonNode)chestNode);
            this.root.put(FIELD_NAME_LEGGINGS, true);
            this.root.put(FIELD_NAME_BOOTS, true);
            this.save();
        } else if (!Files.isRegularFile(configPath, new LinkOption[0])) {
            IOException ex = new IOException("config file " + String.valueOf(HideArmourConfig.getConfigPath()) + " is not a regular file.");
            class_310.method_1551().method_54580(class_128.method_560((Throwable)ex, (String)ex.getMessage()));
        } else {
            this.root = (ObjectNode)JSON_MAPPER.readTree(configPath);
            if (!this.root.has(FIELD_NAME_VERSION) || this.root.get(FIELD_NAME_VERSION).asInt() != 2) {
                try {
                    Files.delete(configPath);
                }
                catch (IOException e) {
                    class_310.method_1551().method_54580(class_128.method_560((Throwable)e, (String)"unable to delete old config file."));
                    return;
                }
                this.init();
            }
        }
    }

    @Contract(mutates="io")
    public void save() {
        JSON_MAPPER.writeValue(HideArmourConfig.getConfigPath(), (Object)this.root);
    }

    @Contract(pure=true)
    public boolean enable() {
        return this.root.get(FIELD_NAME_ENABLE).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig enable(boolean enable) {
        this.root.put(FIELD_NAME_ENABLE, enable);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertEnable() {
        boolean invert = !this.enable();
        this.enable(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean headHelmet() {
        return this.root.get(FIELD_NAME_HEAD).get(FIELD_NAME_HEAD_HELMET).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig headHelmet(boolean helmet) {
        ((ObjectNode)this.root.get(FIELD_NAME_HEAD)).put(FIELD_NAME_HEAD_HELMET, helmet);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertHeadHelmet() {
        boolean invert = !this.headHelmet();
        this.headHelmet(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean headSkull() {
        return this.root.get(FIELD_NAME_HEAD).get(FIELD_NAME_HEAD_SKULL).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig headSkull(boolean headSkull) {
        ((ObjectNode)this.root.get(FIELD_NAME_HEAD)).put(FIELD_NAME_HEAD_SKULL, headSkull);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertHeadSkull() {
        boolean invert = !this.headSkull();
        this.headSkull(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean headBlock() {
        return this.root.get(FIELD_NAME_HEAD).get(FIELD_NAME_HEAD_BLOCK).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig headBlock(boolean headBlock) {
        ((ObjectNode)this.root.get(FIELD_NAME_HEAD)).put(FIELD_NAME_HEAD_BLOCK, headBlock);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertHeadBlock() {
        boolean invert = !this.headBlock();
        this.headBlock(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean chestChestplate() {
        return this.root.get(FIELD_NAME_CHEST).get(FIELD_NAME_CHEST_CHESTPLATE).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig chestChestplate(boolean chestChestplate) {
        ((ObjectNode)this.root.get(FIELD_NAME_CHEST)).put(FIELD_NAME_CHEST_CHESTPLATE, chestChestplate);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertChestChestplate() {
        boolean invert = !this.chestChestplate();
        this.chestChestplate(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean chestElytra() {
        return this.root.get(FIELD_NAME_CHEST).get(FIELD_NAME_CHEST_ELYTRA).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig chestElytra(boolean chestElytra) {
        ((ObjectNode)this.root.get(FIELD_NAME_CHEST)).put(FIELD_NAME_CHEST_ELYTRA, chestElytra);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertChestElytra() {
        boolean invert = !this.chestElytra();
        this.chestElytra(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean leggings() {
        return this.root.get(FIELD_NAME_LEGGINGS).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig leggings(boolean leggings) {
        this.root.put(FIELD_NAME_LEGGINGS, leggings);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertLeggings() {
        boolean invert = !this.leggings();
        this.leggings(invert);
        return invert;
    }

    @Contract(pure=true)
    public boolean boots() {
        return this.root.get(FIELD_NAME_BOOTS).asBoolean();
    }

    @Contract(value="_ -> this", mutates="this")
    public HideArmourConfig boots(boolean boots) {
        this.root.put(FIELD_NAME_BOOTS, boots);
        return this;
    }

    @Contract(mutates="this")
    public boolean invertBoots() {
        boolean invert = !this.boots();
        this.boots(invert);
        return invert;
    }
}

