/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.sawmill;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.common.trades.SubTradesNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import com.yanny.ali.plugin.mods.sawmill.Utils;
import com.yanny.ali.plugin.mods.sawmill.WoodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="net.mehvahdjukaar.sawmill.CarpenterTrades$WoodToItemListing")
public class WoodToItemListing
extends BaseAccessor<VillagerTrades.ItemListing>
implements IItemListing {
    private static final Logger LOGGER = LogUtils.getLogger();
    @FieldAccessor
    private boolean buys;
    @FieldAccessor
    private String childKey;
    @FieldAccessor
    private int woodPrice;
    @FieldAccessor
    private ItemCost emeralds;
    @FieldAccessor
    private int maxTrades;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMult;
    @FieldAccessor
    private boolean typeDependant;

    public WoodToItemListing(VillagerTrades.ItemListing parent) {
        super(parent);
    }

    @Override
    public IDataNode getNode(IServerUtils utils, ITooltipNode conditions) {
        return new SubTradesNode<WoodToItemListing>(utils, this, conditions){

            @Override
            public List<IDataNode> getSubTrades(IServerUtils utils, WoodToItemListing listing) {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                if (WoodToItemListing.this.typeDependant) {
                    for (VillagerType type : BuiltInRegistries.f_256934_) {
                        List<WoodType> woodTypes = Utils.WOOD_TYPES.get(type);
                        if (woodTypes == null) continue;
                        nodes.addAll(WoodToItemListing.this.getNodes(utils, woodTypes, utils.getValueTooltip(utils, type.toString()).build("ali.property.value.villager_type")));
                    }
                } else {
                    nodes.addAll(WoodToItemListing.this.getNodes(utils, WoodToItemListing.getAllWoodTypes(), EmptyTooltipNode.EMPTY));
                }
                return nodes;
            }
        };
    }

    @Override
    public Pair<List<Item>, List<Item>> collectItems(IServerUtils utils) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList<Object> outputs = new ArrayList<Object>();
        List typed = BuiltInRegistries.f_256934_.m_123024_().map(Utils.WOOD_TYPES::get).filter(Objects::nonNull).flatMap(e -> e.stream().flatMap(w -> {
            Item child = w.getItemOfThis(this.childKey);
            return child != null ? Stream.of(child) : Stream.of(new Item[0]);
        })).toList();
        List allTypes = WoodToItemListing.getAllWoodTypes().stream().flatMap(w -> {
            Item child = w.getItemOfThis(this.childKey);
            return child != null ? Stream.of(child) : Stream.of(new Item[0]);
        }).toList();
        if (this.typeDependant) {
            if (this.buys) {
                inputs.addAll(typed);
                outputs.add((Item)this.emeralds.f_316448_().m_203334_());
            } else {
                inputs.add((Item)this.emeralds.f_316448_().m_203334_());
                outputs.addAll(typed);
            }
        } else if (this.buys) {
            inputs.addAll(allTypes);
            outputs.add((Item)this.emeralds.f_316448_().m_203334_());
        } else {
            inputs.add((Item)this.emeralds.f_316448_().m_203334_());
            outputs.addAll(allTypes);
        }
        return new Pair(inputs, outputs);
    }

    @NotNull
    private List<IDataNode> getNodes(IServerUtils utils, Collection<WoodType> woodTypes, ITooltipNode cond) {
        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
        for (WoodType woodType : woodTypes) {
            Item w = woodType.getItemOfThis(this.childKey);
            if (w == null || w.m_7968_().m_41619_()) continue;
            if (this.buys) {
                nodes.add(new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)w.m_7968_()), new RangeValue(this.woodPrice), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)((Item)this.emeralds.f_316448_().m_203334_()).m_7968_()), new RangeValue(this.emeralds.f_314096_()), this.maxTrades, this.xp, this.priceMult, cond));
                continue;
            }
            nodes.add(new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)((Item)this.emeralds.f_316448_().m_203334_()).m_7968_()), new RangeValue(this.emeralds.f_314096_()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)w.m_7968_()), new RangeValue(this.woodPrice), this.maxTrades, this.xp, this.priceMult, cond));
        }
        return nodes;
    }

    private static Collection<WoodType> getAllWoodTypes() {
        try {
            Class<?> registryClass = Class.forName("net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry");
            return ((Collection)registryClass.getMethod("getTypes", new Class[0]).invoke(null, new Object[0])).stream().map(e -> ReflectionUtils.copyClassData(WoodType.class, e)).toList();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            LOGGER.warn("Unable to obtain all wood types: {}", (Object)e2.getMessage());
            return Collections.emptyList();
        }
    }
}

