/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class JeiBaseLoot<T extends IType, V>
implements IRecipeCategory<RecipeHolder<T>> {
    static final int CATEGORY_WIDTH = 162;
    static final int CATEGORY_HEIGHT = 126;
    private final RecipeType<RecipeHolder<T>> recipeType;
    private final LootCategory<V> lootCategory;
    private final Component title;
    private final IDrawable icon;
    protected final IGuiHelper guiHelper;

    public JeiBaseLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<T>> recipeType, LootCategory<V> lootCategory, Component title, IDrawable icon) {
        this.guiHelper = guiHelper;
        this.recipeType = recipeType;
        this.lootCategory = lootCategory;
        this.title = title;
        this.icon = icon;
    }

    @NotNull
    public final RecipeType<RecipeHolder<T>> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public final Component getTitle() {
        return this.title;
    }

    @NotNull
    public final IDrawable getIcon() {
        return this.icon;
    }

    public LootCategory<V> getLootCategory() {
        return this.lootCategory;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<T> recipe, IFocusGroup iFocusGroup) {
        LinkedList<Holder> slotParams = new LinkedList<Holder>();
        IWidgetUtils utils = this.getJeiUtils(slotParams);
        RelativeRect rect = new RelativeRect(0, this.getYOffset(recipe.type()), 162, 0);
        recipe.setWidget(this.getRootWidget(utils, recipe.type().entry(), rect, 162));
        recipe.setHolders(slotParams);
        recipe.type().inputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(i));
        recipe.type().outputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(i));
        for (int i2 = 0; i2 < slotParams.size(); ++i2) {
            Holder h = (Holder)slotParams.get(i2);
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, h.rect.getX() + 1, h.rect.getY() + 1).setSlotName(String.valueOf(i2)).addTooltipCallback((iRecipeSlotView, tooltipBuilder) -> tooltipBuilder.addAll(NodeUtils.toComponents(h.entry().getTooltip(), 0, Minecraft.getInstance().options.advancedItemTooltips)));
            Optional left = h.item.left();
            Optional right = h.item.right();
            left.ifPresent(arg_0 -> ((IRecipeSlotBuilder)slotBuilder).addItemStack(arg_0));
            right.ifPresent(t -> slotBuilder.addIngredients(Ingredient.of((TagKey)t)));
        }
    }

    public void draw(RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IWidget widget = recipe.getWidget();
        List<Holder> slotParams = recipe.getHolders();
        if (widget == null || slotParams == null) {
            return;
        }
        widget.render(guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.renderTooltip(Minecraft.getInstance().font, widget.getTooltipComponents((int)mouseX, (int)mouseY), Optional.empty(), (int)mouseX, (int)mouseY);
        for (int i = 0; i < slotParams.size(); ++i) {
            Holder h = slotParams.get(i);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, h.rect.getX(), h.rect.getY());
            recipeSlotsView.findSlotByName(String.valueOf(i)).ifPresent(slotView -> {
                RangeValue value = ((IItemNode)((Object)h.entry)).getCount();
                if (value.isRange() || value.min() > 1.0f) {
                    MutableComponent count = Component.literal((String)value.toIntString());
                    boolean isRange = value.isRange();
                    Font font = Minecraft.getInstance().font;
                    PoseStack stack = guiGraphics.pose();
                    stack.pushPose();
                    stack.translate((float)h.rect.getX(), (float)h.rect.getY(), 0.0f);
                    if (isRange) {
                        stack.translate(17.0f, 13.0f, 200.0f);
                        stack.pushPose();
                        stack.scale(0.5f, 0.5f, 0.5f);
                        guiGraphics.drawString(font, (Component)count, -font.width((FormattedText)count), 0, 0xFFFFFF, false);
                        stack.popPose();
                    } else {
                        stack.translate(18.0f, 10.0f, 200.0f);
                        guiGraphics.drawString(font, (Component)count, -font.width((FormattedText)count), 0, 0xFFFFFF, true);
                    }
                    stack.popPose();
                }
            });
        }
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 1024;
    }

    abstract int getYOffset(T var1);

    abstract IWidget getRootWidget(IWidgetUtils var1, IDataNode var2, RelativeRect var3, int var4);

    @NotNull
    private IWidgetUtils getJeiUtils(final List<Holder> slotParams) {
        return new ClientUtils(this){

            @Override
            public void addSlotWidget(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
                slotParams.add(new Holder(item, entry, rect));
            }
        };
    }

    public record Holder(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
    }
}

