/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ItemNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "item");
    private final ITooltipNode tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final ItemStack itemStack;
    private final RangeValue count;
    private final float chance;

    public ItemNode(IServerUtils utils, LootItem entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.conditions = Stream.concat(conditions.stream(), entry.conditions.stream()).toList();
        this.functions = Stream.concat(functions.stream(), entry.functions.stream()).toList();
        this.chance = chance * (float)entry.weight / (float)sumWeight;
        this.itemStack = TooltipUtils.getItemStack(utils, ((Item)entry.item.value()).getDefaultInstance(), this.functions);
        this.tooltip = EntryTooltipUtils.getSingletonTooltip(utils, (LootPoolSingletonContainer)entry, chance, sumWeight, functions, conditions);
        this.count = TooltipUtils.getCount(utils, this.functions).get(null).get(0);
    }

    public ItemNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.itemStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.left((Object)this.itemStack);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.itemStack);
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode((FriendlyByteBuf)buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

