/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.LootPoolNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableNode
extends ListNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "loot_table");
    private final ITooltipNode tooltip;

    public LootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, LootTable lootTable) {
        this(modifiers, utils, lootTable, 1.0f, Collections.emptyList(), Collections.emptyList());
    }

    public LootTableNode(IServerUtils utils, LootTable lootTable, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this(Collections.emptyList(), utils, lootTable, chance, functions, conditions);
    }

    public LootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, LootTable lootTable, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), lootTable.functions.stream()).toList();
        this.tooltip = EntryTooltipUtils.getLootTableTooltip();
        for (LootPool lootPool : lootTable.pools) {
            this.addChildren(new LootPoolNode(utils, lootPool, chance, allFunctions, conditions));
        }
        for (ILootModifier iLootModifier : modifiers) {
            NodeUtils.processLootModifier(utils, iLootModifier, this);
        }
    }

    public LootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils) {
        this.tooltip = EntryTooltipUtils.getLootTableTooltip();
        for (ILootModifier<?> modifier : modifiers) {
            NodeUtils.processLootModifier(utils, modifier, this);
        }
    }

    public LootTableNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        super(utils, buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

