/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getChance(IServerUtils utils, List<LootItemCondition> conditions, float rawChance) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> chance = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (LootItemCondition condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IServerUtils utils, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static ItemStack getItemStack(IServerUtils utils, ItemStack itemStack, List<LootItemFunction> functions) {
        for (LootItemFunction function : functions) {
            itemStack = utils.applyItemStackModifier(utils, function, itemStack);
        }
        return itemStack;
    }

    public static void applyRandomChance(IServerUtils utils, LootItemRandomChanceCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.probability());
            }
        }
    }

    public static void applyRandomChanceWithLooting(IServerUtils utils, LootItemRandomChanceWithLootingCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        Holder enchantment = Holder.direct((Object)Enchantments.LOOTING);
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.percent());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.percent() + (float)entry.getKey().intValue() * condition.lootingMultiplier());
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.percent());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.percent() + (float)level * condition.lootingMultiplier()));
            }
        }
    }

    public static void applyTableBonus(IServerUtils utils, BonusLevelTableCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        block2: {
            Holder enchantment;
            block3: {
                enchantment = condition.enchantment();
                if (condition.values().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.values().getFirst()).floatValue());
                if (condition.values().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.values().size()) continue;
                    entry.getValue().multiply(((Float)condition.values().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.values().getFirst()).floatValue());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel() && level < condition.values().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.values().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IServerUtils utils, SetItemCountFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        if (function.predicates.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.add) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.value));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.value));
                }
            }
        }
    }

    public static void applyBonus(IServerUtils utils, ApplyBonusCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.predicates.isEmpty()) break block4;
            Holder enchantment = function.enchantment;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IServerUtils utils, LimitCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> bonusCount) {
        if (function.predicates.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.limiter.min), utils.convertNumber(utils, function.limiter.max));
                }
            }
        }
    }

    public static void applyLootingEnchant(IServerUtils utils, LootingEnchantFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.predicates.isEmpty()) break block5;
            Holder enchantment = Holder.direct((Object)Enchantments.LOOTING);
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.value).multiply(entry.getKey().intValue()));
                    if (function.limit <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.limit));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.value).multiply(level));
                    if (function.limit > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.limit));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static ItemStack applyEnchantRandomlyItemStackModifier(IServerUtils utils, EnchantRandomlyFunction function, ItemStack itemStack) {
        if (itemStack.isEnchantable() && function.predicates.isEmpty()) {
            List<Holder.Reference> list;
            boolean isBook = itemStack.is(Items.BOOK);
            ItemStack finalItemStack = itemStack;
            Optional<HolderSet.Direct> enchantments = function.enchantments;
            if (enchantments.isEmpty() && (list = BuiltInRegistries.ENCHANTMENT.holders().filter(ref -> ((Enchantment)ref.value()).isDiscoverable()).filter(ref -> isBook || ((Enchantment)ref.value()).canEnchant(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(HolderSet.direct((Holder[])new Holder[]{(Holder)list.getFirst()}));
            }
            if (enchantments.isPresent() && ((HolderSet)enchantments.get()).size() == 1 && ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMinLevel() == ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMaxLevel()) {
                itemStack.enchant((Enchantment)((HolderSet)enchantments.get()).get(0).value(), ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMaxLevel());
            } else if (isBook) {
                itemStack = Items.ENCHANTED_BOOK.getDefaultInstance();
            } else {
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applyEnchantWithLevelsItemStackModifier(IServerUtils utils, EnchantWithLevelsFunction function, ItemStack itemStack) {
        if (itemStack.isEnchantable() && function.predicates.isEmpty()) {
            if (itemStack.is(Items.BOOK)) {
                itemStack = Items.ENCHANTED_BOOK.getDefaultInstance();
            } else {
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
        }
        return itemStack;
    }

    public static ItemStack applySetAttributesItemStackModifier(IServerUtils utils, SetAttributesFunction function, ItemStack itemStack) {
        if (function.predicates.isEmpty()) {
            if (function.replace) {
                itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)TooltipUtils.updateModifiers(function.modifiers, ItemAttributeModifiers.EMPTY));
            } else {
                itemStack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> {
                    if (modifiers.modifiers().isEmpty()) {
                        return TooltipUtils.updateModifiers(function.modifiers, itemStack.getItem().getDefaultAttributeModifiers());
                    }
                    return TooltipUtils.updateModifiers(function.modifiers, modifiers);
                });
            }
        }
        return itemStack;
    }

    public static ItemStack applySetNameItemStackModifier(IServerUtils utils, SetNameFunction function, ItemStack itemStack) {
        if (function.predicates.isEmpty() && function.name.isPresent()) {
            itemStack.set(function.target.component(), (Object)((Component)function.name.get()));
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applySetEnchantmentsItemStackModifier(IServerUtils utils, SetEnchantmentsFunction function, ItemStack itemStack) {
        if (itemStack.isEnchantable() && function.predicates.isEmpty()) {
            if (itemStack.is(Items.BOOK)) {
                itemStack = Items.ENCHANTED_BOOK.getDefaultInstance();
            } else {
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
        }
        return itemStack;
    }

    public static ItemStack applyItemStackModifier(IServerUtils utils, LootItemFunction function, ItemStack itemStack) {
        if (function instanceof LootItemConditionalFunction) {
            LootItemConditionalFunction conditional = (LootItemConditionalFunction)function;
            if (!conditional.predicates.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (ItemStack)function.apply((Object)itemStack, null);
        return itemStack;
    }

    public static void addObjectFields(IServerUtils utils, IKeyTooltipNode tooltip, Object object, Class<?> baseClass) {
        List<Field> fields = TooltipUtils.getAllFields(object.getClass(), baseClass);
        List<Field> names = fields.stream().filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t;
                Object obj = f.get(object);
                if (obj instanceof LootItemCondition) {
                    LootItemCondition condition = (LootItemCondition)obj;
                    t = BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, Collections.singletonList(condition)));
                } else if (obj instanceof LootItemFunction) {
                    LootItemFunction function = (LootItemFunction)obj;
                    t = BranchTooltipNode.branch().add(GenericTooltipUtils.getFunctionListTooltip(utils, Collections.singletonList(function)));
                } else {
                    t = utils.getValueTooltip(utils, obj);
                }
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName() + ":", false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "[" + f.getType().getName() + "]").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static IKeyTooltipNode getArrayTooltip(IServerUtils utils, Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        int length = Array.getLength(value);
        if (componentType == LootItemCondition.class) {
            ArrayList<LootItemCondition> values = new ArrayList<LootItemCondition>();
            for (int i = 0; i < length; ++i) {
                values.add((LootItemCondition)Array.get(value, i));
            }
            return GenericTooltipUtils.getSubConditionsTooltip(utils, values);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                if (element instanceof LootItemCondition) {
                    LootItemCondition condition = (LootItemCondition)element;
                    tooltip.add(GenericTooltipUtils.getConditionListTooltip(utils, Collections.singletonList(condition)));
                    continue;
                }
                if (element instanceof LootItemFunction) {
                    LootItemFunction function = (LootItemFunction)element;
                    tooltip.add(GenericTooltipUtils.getFunctionListTooltip(utils, Collections.singletonList(function)));
                    continue;
                }
                IKeyTooltipNode t = utils.getValueTooltip(utils, element);
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build("ali.property.value.null"));
                    continue;
                }
                if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build("ali.property.branch.values"));
                    continue;
                }
                if (!(t instanceof ErrorTooltipNode.Builder)) continue;
                tooltip.add(utils.getValueTooltip(utils, element).build("ali.property.value.null"));
            }
        } else {
            return ValueTooltipNode.value("[]");
        }
        return tooltip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void calculateCount(ApplyBonusCount function, RangeValue value, int level) {
        ApplyBonusCount.Formula formula = function.formula;
        Objects.requireNonNull(formula);
        ApplyBonusCount.Formula formula2 = formula;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyBonusCount.OreDrops.class, ApplyBonusCount.BinomialWithBonusCount.class, ApplyBonusCount.UniformBonusCount.class}, (Object)formula2, n)) {
            case 0: {
                ApplyBonusCount.OreDrops ignored = (ApplyBonusCount.OreDrops)formula2;
                if (level <= 0) return;
                value.multiplyMax(level + 1);
                return;
            }
            case 1: {
                ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula2;
                value.addMax(binomialWithBonusCount.extraRounds() + level);
                return;
            }
            case 2: {
                ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula2;
                try {
                    int n2;
                    int bonusMultiplier = n2 = uniformBonusCount.bonusMultiplier();
                    if (level <= 0) return;
                    value.addMax(bonusMultiplier * level);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    @NotNull
    private static List<Field> getAllFields(Class<?> clazz, Class<?> baseClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != baseClass && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(fields, declaredFields);
        }
        return fields;
    }

    private static ItemAttributeModifiers updateModifiers(List<SetAttributesFunction.Modifier> modifiers, ItemAttributeModifiers itemAttributeModifiers) {
        for (SetAttributesFunction.Modifier modifier : modifiers) {
            UUID id = modifier.id().orElse(UUID.randomUUID());
            if (modifier.slots().size() != 1 || modifier.amount().getType() != NumberProviders.CONSTANT) continue;
            EquipmentSlotGroup equipmentSlot = (EquipmentSlotGroup)Util.getRandom((List)modifier.slots(), (RandomSource)RandomSource.create());
            ConstantValue value = (ConstantValue)modifier.amount();
            itemAttributeModifiers = itemAttributeModifiers.withModifierAdded(modifier.attribute(), new AttributeModifier(id, modifier.name(), (double)value.getFloat(null), modifier.operation()), equipmentSlot);
        }
        return itemAttributeModifiers;
    }
}

