/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public final class RangeValue {
    private float min;
    private float max;
    private boolean isRange = false;
    private boolean hasScore = false;
    private boolean isUnknown = false;

    public RangeValue() {
        this(1.0f);
    }

    public RangeValue(RangeValue value) {
        this.min = value.min;
        this.max = value.max;
        this.isRange = value.isRange;
        this.hasScore = value.hasScore;
        this.isUnknown = value.isUnknown;
    }

    public RangeValue(boolean hasScore, boolean isUnknown) {
        this(1.0f);
        this.hasScore = hasScore;
        this.isUnknown = isUnknown;
    }

    public RangeValue(float value) {
        this.min = this.max = value;
    }

    public RangeValue(float min, float max) {
        this.min = min;
        this.max = max;
        this.isRange = true;
    }

    public RangeValue(class_2540 buf) {
        this.min = buf.readFloat();
        this.max = buf.readFloat();
        this.isRange = buf.readBoolean();
        this.hasScore = buf.readBoolean();
        this.isUnknown = buf.readBoolean();
    }

    public RangeValue multiply(float value) {
        this.min *= value;
        this.max *= value;
        return this;
    }

    public RangeValue multiply(RangeValue value) {
        this.min *= value.min;
        this.max *= value.max;
        this.isRange |= value.isRange;
        this.isUnknown |= value.isUnknown;
        return this;
    }

    public void multiplyMax(float value) {
        this.max *= value;
        this.isRange = true;
    }

    public void addMax(float value) {
        this.max += value;
        this.isRange = true;
    }

    public RangeValue add(float value) {
        this.min += value;
        this.max += value;
        return this;
    }

    public RangeValue add(RangeValue value) {
        if (this.isRange || value.isRange) {
            this.min += value.min;
            this.max += value.max;
        } else {
            this.min = this.max = this.min + value.min;
        }
        this.isRange |= value.isRange;
        this.hasScore |= value.hasScore;
        this.isUnknown |= value.isUnknown;
        return this;
    }

    public void set(RangeValue value) {
        this.min = value.min;
        this.max = value.max;
        this.isRange = value.isRange;
        this.hasScore = value.hasScore;
        this.isUnknown = value.isUnknown;
    }

    public float min() {
        return this.min;
    }

    public float max() {
        return this.max;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public boolean isUnknown() {
        return this.isUnknown;
    }

    public RangeValue clamp(RangeValue min, RangeValue max) {
        if (this.min < min.min && !min.isUnknown && !this.isUnknown) {
            this.min = min.min;
            if (this.max < min.min) {
                this.max = min.min;
                this.isRange = false;
            }
        }
        if (this.max > max.max && !max.isUnknown && !this.isUnknown) {
            this.max = max.max;
            if (this.min > max.max) {
                this.min = max.max;
                this.isRange = false;
            }
        }
        return this;
    }

    public RangeValue clamp(float min, float max) {
        if (this.min < min) {
            this.min = min;
        }
        if (this.max > max) {
            this.max = max;
        }
        return this;
    }

    @NotNull
    public String toIntString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRange) {
            sb.append(Math.round(this.min)).append("-").append(Math.round(this.max));
        } else {
            sb.append(Math.round(this.min));
        }
        if (this.hasScore) {
            sb.append("[+Score]");
        }
        if (this.isUnknown) {
            sb.append("[+???]");
        }
        return sb.toString();
    }

    @NotNull
    public String toFloatString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRange) {
            sb.append(RangeValue.format(this.min)).append("-").append(RangeValue.format(this.max));
        } else {
            sb.append(RangeValue.format(this.min));
        }
        if (this.hasScore) {
            sb.append("[+Score]");
        }
        if (this.isUnknown) {
            sb.append("[+???]");
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        return this.toFloatString();
    }

    @NotNull
    private static String format(float value) {
        if ((float)Math.round(value * 100.0f) / 100.0f == (float)((int)value)) {
            return String.format("%d", (int)value);
        }
        return String.format("%.2f", Float.valueOf(value));
    }

    @NotNull
    public static String rangeToString(RangeValue min, RangeValue max) {
        if (min.isUnknown()) {
            return "\u2264" + String.valueOf(max);
        }
        if (max.isUnknown()) {
            return "\u2265" + String.valueOf(min);
        }
        if (min.toString().equals(max.toString())) {
            return "=" + String.valueOf(min);
        }
        return String.valueOf(min) + " - " + String.valueOf(max);
    }
}

