/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBlockLoot;
import com.yanny.ali.compatibility.jei.JeiEntityLoot;
import com.yanny.ali.compatibility.jei.JeiGameplayLoot;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<JeiBlockLoot> blockCategoryList = new LinkedList<JeiBlockLoot>();
    private final List<JeiEntityLoot> entityCategoryList = new LinkedList<JeiEntityLoot>();
    private final List<JeiGameplayLoot> gameplayCategoryList = new LinkedList<JeiGameplayLoot>();

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.PLANT_LOOT, BlockLootType.class, JeiBlockLoot::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, BlockLootType.class, JeiBlockLoot::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.BLOCK_LOOT, BlockLootType.class, JeiBlockLoot::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, EntityLootType.class, JeiEntityLoot::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.ENTITY_LOOT, EntityLootType.class, JeiEntityLoot::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, GameplayLootType.class, JeiGameplayLoot::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.GAMEPLAY_LOOT, GameplayLootType.class, JeiGameplayLoot::new));
        this.blockCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.entityCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.gameplayCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    /*
     * WARNING - void declaration
     */
    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_5321<class_52> location;
            Map<class_5321<class_52>, class_52> map = GenericUtils.getLootTables();
            HashMap<RecipeType, List> blockRecipeTypes = new HashMap<RecipeType, List>();
            HashMap<RecipeType, List> entityRecipeTypes = new HashMap<RecipeType, List>();
            HashMap<RecipeType, List> gameplayRecipeTypes = new HashMap<RecipeType, List>();
            for (class_2248 class_22482 : class_7923.field_41175) {
                void var11_21;
                location = class_22482.method_26162();
                class_1767[] lootEntry = map.get(location);
                if (lootEntry == null) continue;
                Object var11_22 = null;
                for (JeiBlockLoot recipeCategory : this.blockCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(class_22482)) continue;
                    RecipeType recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (var11_21 != null) {
                    blockRecipeTypes.computeIfAbsent((RecipeType)var11_21, p -> new LinkedList()).add(new BlockLootType(class_22482, (class_52)lootEntry, GenericUtils.getItems(location)));
                }
                map.remove(location);
            }
            for (class_1299 class_12992 : class_7923.field_41177) {
                LinkedList<Object> entityList = new LinkedList<Object>();
                if (class_12992 == class_1299.field_6115) {
                    class_1472 sheep;
                    for (class_1767 color : class_1767.values()) {
                        void sheep2;
                        try {
                            class_1472 sheep22 = (class_1472)class_12992.method_5883((class_1937)level);
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.method_15434(), (Object)e.getMessage());
                            continue;
                        }
                        if (sheep2 == null) continue;
                        sheep2.method_6631(color);
                        entityList.add(sheep2);
                    }
                    try {
                        sheep = (class_1472)class_12992.method_5883((class_1937)level);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create sheep: {}", (Object)throwable.getMessage());
                        continue;
                    }
                    if (sheep != null) {
                        sheep.method_6635(true);
                        entityList.add(sheep);
                    }
                } else {
                    class_1297 entity;
                    try {
                        entity = class_12992.method_5883((class_1937)level);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create entity {}: {}", (Object)class_7923.field_41177.method_10221((Object)class_12992), (Object)throwable.getMessage());
                        continue;
                    }
                    entityList.add(entity);
                }
                for (class_1297 class_12972 : entityList) {
                    class_1308 mob;
                    class_5321 location2;
                    class_52 lootEntry;
                    if (!(class_12972 instanceof class_1308) || (lootEntry = map.get(location2 = (mob = (class_1308)class_12972).method_5989())) == null) continue;
                    RecipeType recipeType = null;
                    for (JeiEntityLoot recipeCategory : this.entityCategoryList) {
                        if (!recipeCategory.getLootCategory().validate(class_12972)) continue;
                        recipeType = recipeCategory.getRecipeType();
                        break;
                    }
                    if (recipeType != null) {
                        entityRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new EntityLootType(class_12972, lootEntry, GenericUtils.getItems((class_5321<class_52>)location2)));
                    }
                    map.remove(location2);
                }
            }
            for (Map.Entry<class_5321<class_52>, class_52> entry : map.entrySet()) {
                location = entry.getKey();
                RecipeType recipeType = null;
                for (JeiGameplayLoot recipeCategory : this.gameplayCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(location.method_29177().method_12832())) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType == null) continue;
                gameplayRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new GameplayLootType(entry.getValue(), "/" + location.method_29177().method_12832(), GenericUtils.getItems(location)));
            }
            for (Map.Entry<Object, Object> entry : blockRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : entityRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : gameplayRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), (List)entry.getValue());
            }
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    public class_2960 getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }

    private static <T, U, V> T createCategory(IGuiHelper guiHelper, LootCategory<U> e, Class<V> clazz, LootConstructor<T, U, V> constructor) {
        RecipeType recipeType = RecipeType.create((String)"ali", (String)e.getKey(), clazz);
        class_5250 title = class_2561.method_43471((String)("emi.category.ali." + e.getKey().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e, (class_2561)title, guiHelper.createDrawableItemStack(e.getIcon()));
    }

    private static <T, U, V> T createCategory(IGuiHelper guiHelper, Map.Entry<class_2960, LootCategory<U>> e, Class<V> clazz, LootConstructor<T, U, V> constructor) {
        class_2960 id = e.getKey();
        RecipeType recipeType = RecipeType.create((String)id.method_12836(), (String)id.method_12832(), clazz);
        class_5250 title = class_2561.method_43471((String)("emi.category." + id.method_12836() + "." + id.method_12832().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e.getValue(), (class_2561)title, guiHelper.createDrawableItemStack(e.getValue().getIcon()));
    }

    @FunctionalInterface
    private static interface LootConstructor<T, U, V> {
        public T construct(IGuiHelper var1, RecipeType<V> var2, LootCategory<U> var3, class_2561 var4, IDrawable var5);
    }
}

