/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.EntryTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5341;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public abstract class JeiBaseLoot<T extends IType, V>
implements IRecipeCategory<T> {
    private static final Map<IType, Pair<IWidget, List<ISlotParams>>> widgets = new HashMap<IType, Pair<IWidget, List<ISlotParams>>>();
    private final RecipeType<T> recipeType;
    private final LootCategory<V> lootCategory;
    private final class_2561 title;
    private final IDrawable icon;
    protected final IGuiHelper guiHelper;

    public JeiBaseLoot(IGuiHelper guiHelper, RecipeType<T> recipeType, LootCategory<V> lootCategory, class_2561 title, IDrawable icon) {
        this.guiHelper = guiHelper;
        this.recipeType = recipeType;
        this.lootCategory = lootCategory;
        this.title = title;
        this.icon = icon;
    }

    @NotNull
    public final RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public final class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public final IDrawable getIcon() {
        return this.icon;
    }

    public LootCategory<V> getLootCategory() {
        return this.lootCategory;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup iFocusGroup) {
        LinkedList<ISlotParams> slotParams = new LinkedList<ISlotParams>();
        IWidgetUtils utils = this.getJeiUtils(slotParams);
        widgets.put((IType)recipe, (Pair<IWidget, List<ISlotParams>>)new Pair((Object)new LootTableWidget(utils, recipe.entry(), 0, this.getYOffset(recipe)), slotParams));
        for (int i = 0; i < slotParams.size(); ++i) {
            ISlotParams p = (ISlotParams)slotParams.get(i);
            if (p instanceof ItemSlotParams) {
                ItemSlotParams itemSlotParams = (ItemSlotParams)p;
                builder.addSlot(RecipeIngredientRole.OUTPUT, itemSlotParams.x + 1, itemSlotParams.y + 1).setSlotName(String.valueOf(i)).addRichTooltipCallback((iRecipeSlotView, components) -> components.addAll(EntryTooltipUtils.getTooltip(utils, p.entry(), p.chance(), p.count(), p.allFunctions(), p.allConditions()))).addItemStack(itemSlotParams.item);
                continue;
            }
            if (!(p instanceof TagSlotParams)) continue;
            TagSlotParams tagSlotParams = (TagSlotParams)p;
            builder.addSlot(RecipeIngredientRole.OUTPUT, tagSlotParams.x + 1, tagSlotParams.y + 1).setSlotName(String.valueOf(i)).addRichTooltipCallback((iRecipeSlotView, components) -> components.addAll(EntryTooltipUtils.getTooltip(utils, p.entry(), p.chance(), p.count(), p.allFunctions(), p.allConditions()))).addIngredients(class_1856.method_8106(tagSlotParams.item));
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        Pair<IWidget, List<ISlotParams>> pair = widgets.get(recipe);
        if (pair == null) {
            return;
        }
        IWidget widget = (IWidget)pair.getA();
        List slotParams = (List)pair.getB();
        widget.render(guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.method_51437(class_310.method_1551().field_1772, widget.getTooltipComponents((int)mouseX, (int)mouseY), Optional.empty(), (int)mouseX, (int)mouseY);
        for (int i = 0; i < slotParams.size(); ++i) {
            ISlotParams p = (ISlotParams)slotParams.get(i);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, p.x(), p.y());
            recipeSlotsView.findSlotByName(String.valueOf(i)).ifPresent(slotView -> {
                RangeValue value = p.count().get(null).get(0);
                if (value.isRange() || value.min() > 1.0f) {
                    class_5250 count = class_2561.method_43470((String)value.toIntString());
                    boolean isRange = value.isRange();
                    class_327 font = class_310.method_1551().field_1772;
                    class_4587 stack = guiGraphics.method_51448();
                    stack.method_22903();
                    stack.method_46416((float)p.x(), (float)p.y(), 0.0f);
                    if (isRange) {
                        stack.method_46416(17.0f, 13.0f, 200.0f);
                        stack.method_22903();
                        stack.method_22905(0.5f, 0.5f, 0.5f);
                        guiGraphics.method_51439(font, (class_2561)count, -font.method_27525((class_5348)count), 0, 0xFFFFFF, false);
                        stack.method_22909();
                    } else {
                        stack.method_46416(18.0f, 10.0f, 200.0f);
                        guiGraphics.method_51439(font, (class_2561)count, -font.method_27525((class_5348)count), 0, 0xFFFFFF, true);
                    }
                    stack.method_22909();
                }
            });
        }
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 1024;
    }

    abstract int getYOffset(T var1);

    @NotNull
    private IWidgetUtils getJeiUtils(final List<ISlotParams> slotParams) {
        return new ClientUtils(this){

            @Override
            public Rect addSlotWidget(class_1792 item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) {
                class_1799 itemStack = TooltipUtils.getItemStack(this, entry, item);
                slotParams.add(new ItemSlotParams(itemStack, entry, x, y, chance, count, allFunctions, allConditions));
                return new Rect(x, y, 18, 18);
            }

            @Override
            public Rect addSlotWidget(class_6862<class_1792> item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) {
                slotParams.add(new TagSlotParams(item, entry, x, y, chance, count, allFunctions, allConditions));
                return new Rect(x, y, 18, 18);
            }
        };
    }

    private static interface ISlotParams {
        public class_79 entry();

        public int x();

        public int y();

        public Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance();

        public Map<class_6880<class_1887>, Map<Integer, RangeValue>> count();

        public List<class_117> allFunctions();

        public List<class_5341> allConditions();
    }

    private record ItemSlotParams(class_1799 item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) implements ISlotParams
    {
    }

    private record TagSlotParams(class_6862<class_1792> item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) implements ISlotParams
    {
    }
}

