/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiWidgetWrapper;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.EntryTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.registries.LootCategory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5341;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReiBaseCategory<T extends ReiBaseDisplay, U>
implements DisplayCategory<T> {
    private final LootCategory<U> lootCategory;

    public ReiBaseCategory(LootCategory<U> lootCategory) {
        this.lootCategory = lootCategory;
    }

    public abstract List<Widget> setupDisplay(T var1, Rectangle var2);

    public int getDisplayWidth(T display) {
        return 170;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public LootCategory<U> getLootCategory() {
        return this.lootCategory;
    }

    protected List<Widget> getBaseWidget(T display, Rectangle bounds, int x, int y) {
        LinkedList<Widget> slotWidgets = new LinkedList<Widget>();
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        ReiWidgetWrapper widget = new ReiWidgetWrapper(new LootTableWidget(this.getUtils(slotWidgets, bounds), ((ReiBaseDisplay)((Object)display)).getLootEntry(), x + 4, y + 4), bounds);
        widgets.add(Widgets.createTooltip(widget::getTooltip));
        widgets.add((Widget)widget);
        widgets.addAll(slotWidgets);
        return widgets;
    }

    @NotNull
    private IWidgetUtils getUtils(final List<Widget> widgets, final Rectangle bounds) {
        return new ClientUtils(this){

            @Override
            public Rect addSlotWidget(class_1792 item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) {
                class_1799 itemStack = TooltipUtils.getItemStack(this, entry, item);
                EntryStack stack = EntryStacks.of((class_1799)itemStack);
                stack.tooltip(EntryTooltipUtils.getTooltip(this, entry, chance, count, allFunctions, allConditions));
                widgets.add(Widgets.createSlot((Point)new Point(x + bounds.getX() + 1, y + bounds.getY() + 1)).entry(stack).markOutput());
                widgets.add(Widgets.wrapRenderer((Rectangle)new Rectangle(x + bounds.getX(), y + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(count.get(null).get(0))));
                return new Rect(x, y, 18, 18);
            }

            @Override
            public Rect addSlotWidget(class_6862<class_1792> item, class_79 entry, int x, int y, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> allFunctions, List<class_5341> allConditions) {
                EntryIngredient ingredient = EntryIngredients.ofItemTag(item);
                ingredient.map(stack -> stack.tooltip(EntryTooltipUtils.getTooltip(this, entry, chance, count, allFunctions, allConditions)));
                widgets.add(Widgets.createSlot((Point)new Point(x + bounds.getX() + 1, y + bounds.getY() + 1)).entries((Collection)ingredient).markOutput());
                widgets.add(Widgets.wrapRenderer((Rectangle)new Rectangle(x + bounds.getX(), y + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(count.get(null).get(0))));
                return new Rect(x, y, 18, 18);
            }
        };
    }

    private static class SlotCountRenderer
    implements Renderer {
        @Nullable
        private class_2561 count;
        private boolean isRange = false;

        public SlotCountRenderer(RangeValue count) {
            if (count.isRange() || count.min() > 1.0f) {
                this.count = class_2561.method_43470((String)count.toIntString());
                this.isRange = count.isRange();
            }
        }

        public void render(class_332 guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (this.count != null) {
                class_327 font = class_310.method_1551().field_1772;
                class_4587 stack = guiGraphics.method_51448();
                stack.method_22903();
                stack.method_46416((float)bounds.getX(), (float)bounds.getY(), 0.0f);
                if (this.isRange) {
                    stack.method_46416(17.0f, 13.0f, 200.0f);
                    stack.method_22903();
                    stack.method_22905(0.5f, 0.5f, 0.5f);
                    guiGraphics.method_51439(font, this.count, -font.method_27525((class_5348)this.count), 0, 0xFFFFFF, false);
                    stack.method_22909();
                } else {
                    stack.method_46416(18.0f, 10.0f, 200.0f);
                    guiGraphics.method_51439(font, this.count, -font.method_27525((class_5348)this.count), 0, 0xFFFFFF, true);
                }
                stack.method_22909();
            }
        }
    }
}

