/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.EntityHasScoreCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ConditionTooltipUtils {
    private static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("0.####");

    @NotNull
    public static ITooltipNode getAllOfTooltip(IServerUtils utils, AllOfCondition cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.all_of", cond.terms, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getAnyOfTooltip(IServerUtils utils, AnyOfCondition cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.any_of", cond.terms, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getBlockStatePropertyTooltip(IServerUtils utils, LootItemBlockStatePropertyCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.block_state_property", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.block", cond.block(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", cond.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDamageSourcePropertiesTooltip(IServerUtils utils, DamageSourceCondition cond) {
        return GenericTooltipUtils.getOptionalTooltip(utils, "ali.type.condition.damage_source_properties", cond.predicate(), GenericTooltipUtils::getDamageSourcePredicateTooltip);
    }

    @NotNull
    public static ITooltipNode getEntityPropertiesTooltip(IServerUtils utils, LootItemEntityPropertyCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_properties", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.entityTarget()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.predicate", cond.predicate(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityScoresTooltip(IServerUtils utils, EntityHasScoreCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_scores", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.entityTarget()));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.scores", cond.scores(), GenericTooltipUtils::getIntRangeEntryTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getInvertedTooltip(IServerUtils utils, InvertedLootItemCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.inverted", new Object[0]));
        tooltip.add(utils.getConditionTooltip(utils, cond.term()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getKilledByPlayerTooltip(IServerUtils ignoredUtils, LootItemKilledByPlayerCondition ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.killed_by_player", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getLocationCheckTooltip(IServerUtils utils, LocationCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.location_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.location", cond.predicate(), GenericTooltipUtils::getLocationPredicateTooltip));
        if (!cond.offset().equals((Object)BlockPos.ZERO)) {
            tooltip.add(GenericTooltipUtils.getBlockPosTooltip(utils, "ali.property.multi.offset", cond.offset()));
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMatchToolTooltip(IServerUtils utils, MatchTool cond) {
        return GenericTooltipUtils.getOptionalTooltip(utils, "ali.type.condition.match_tool", cond.predicate(), GenericTooltipUtils::getItemPredicateTooltip);
    }

    @NotNull
    public static ITooltipNode getRandomChanceTooltip(IServerUtils utils, LootItemRandomChanceCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(cond.probability())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRandomChanceWithLootingTooltip(IServerUtils utils, LootItemRandomChanceWithLootingCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance_with_looting", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.percent", Float.valueOf(cond.percent())));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.multiplier", Float.valueOf(cond.lootingMultiplier())));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getReferenceTooltip(IServerUtils utils, ConditionReference cond) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.type.condition.reference", cond.name());
    }

    public static @Unmodifiable @NotNull ITooltipNode getSurvivesExplosionTooltip(IServerUtils ignoredUtils, ExplosionCondition ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.survives_explosion", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getTableBonusTooltip(IServerUtils utils, BonusLevelTableCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.table_bonus", new Object[0]), true);
        List<String> list = cond.values().stream().mapToDouble(aFloat -> aFloat.floatValue()).mapToObj(FLOAT_FORMAT::format).toList();
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.enchantment", cond.enchantment(), RegistriesTooltipUtils::getEnchantmentTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.values", list.toString()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getTimeCheckTooltip(IServerUtils utils, TimeCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.time_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.period", cond.period(), GenericTooltipUtils::getLongTooltip));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.value", cond.value()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getValueCheckTooltip(IServerUtils utils, ValueCheckCondition cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.value_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.provider", cond.provider()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.range", cond.range()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getWeatherCheckTooltip(IServerUtils utils, WeatherCheck cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.weather_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_raining", cond.isRaining(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_thundering", cond.isThundering(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }
}

