/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.platform.Services;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void register(EmiRegistry emiRegistry) {
        this.registerLootTable(emiRegistry);
    }

    private void registerLootTable(EmiRegistry registry) {
        AbstractClient client = Services.PLATFORM.getInfoPropagator().client();
        ClientLevel level = Minecraft.getInstance().level;
        if (client != null && level != null) {
            ResourceKey<LootTable> location;
            Map<ResourceKey<LootTable>, LootTable> map = GenericUtils.getLootTables();
            Map<LootCategory, EmiRecipeCategory> blockCategoryMap = LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> entityCategoryMap = LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> gameplayCategoryMap = LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            blockCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            EmiRecipeCategory blockCategory = EmiCompatibility.createCategory(LootCategories.BLOCK_LOOT);
            EmiRecipeCategory plantCategory = EmiCompatibility.createCategory(LootCategories.PLANT_LOOT);
            EmiRecipeCategory entityCategory = EmiCompatibility.createCategory(LootCategories.ENTITY_LOOT);
            EmiRecipeCategory gameplayCategory = EmiCompatibility.createCategory(LootCategories.GAMEPLAY_LOOT);
            registry.addCategory(blockCategory);
            registry.addCategory(plantCategory);
            registry.addCategory(entityCategory);
            registry.addCategory(gameplayCategory);
            for (Block block : BuiltInRegistries.BLOCK) {
                location = block.getLootTable();
                DyeColor[] lootEntry = map.get(location);
                if (lootEntry == null) continue;
                EmiRecipeCategory category = null;
                if (LootCategories.PLANT_LOOT.validate(block)) {
                    category = plantCategory;
                } else {
                    for (Map.Entry<LootCategory, EmiRecipeCategory> entry : blockCategoryMap.entrySet()) {
                        if (!entry.getKey().validate(block)) continue;
                        category = entry.getValue();
                    }
                    if (category == null) {
                        category = blockCategory;
                    }
                }
                registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, new ResourceLocation(location.location().getNamespace(), "/" + location.location().getPath()), block, (LootTable)lootEntry, GenericUtils.getItems(location)));
                map.remove(location);
            }
            for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                LinkedList<Object> entityList = new LinkedList<Object>();
                if (entityType == EntityType.SHEEP) {
                    Sheep sheep;
                    for (DyeColor color : DyeColor.values()) {
                        Sheep sheep2;
                        try {
                            sheep2 = (Sheep)entityType.create((Level)level);
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.getSerializedName(), (Object)e.getMessage());
                            continue;
                        }
                        if (sheep2 == null) continue;
                        sheep2.setColor(color);
                        entityList.add(sheep2);
                    }
                    try {
                        sheep = (Sheep)entityType.create((Level)level);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to create sheep: {}", (Object)e.getMessage());
                        continue;
                    }
                    if (sheep != null) {
                        sheep.setSheared(true);
                        entityList.add(sheep);
                    }
                } else {
                    Entity entity2;
                    try {
                        entity2 = entityType.create((Level)level);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to create entity {}: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType), (Object)e.getMessage());
                        continue;
                    }
                    entityList.add(entity2);
                }
                entityList.forEach(entity -> {
                    Mob mob;
                    ResourceKey location;
                    LootTable lootEntry;
                    if (entity instanceof Mob && (lootEntry = (LootTable)map.get(location = (mob = (Mob)entity).getLootTable())) != null) {
                        EmiRecipeCategory category = null;
                        for (Map.Entry entry : entityCategoryMap.entrySet()) {
                            if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                            category = (EmiRecipeCategory)entry.getValue();
                        }
                        if (category == null) {
                            category = entityCategory;
                        }
                        registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, new ResourceLocation(location.location().getNamespace(), "/" + location.location().getPath()), (Entity)entity, lootEntry, GenericUtils.getItems((ResourceKey<LootTable>)location)));
                        map.remove(location);
                    }
                });
            }
            for (Map.Entry<ResourceKey<LootTable>, LootTable> entry : map.entrySet()) {
                location = entry.getKey();
                EmiRecipeCategory category = null;
                for (Map.Entry<LootCategory, EmiRecipeCategory> gameplayEntry : gameplayCategoryMap.entrySet()) {
                    if (!gameplayEntry.getKey().validate(location.location().getPath())) continue;
                    category = gameplayEntry.getValue();
                }
                if (category == null) {
                    category = gameplayCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, new ResourceLocation(location.location().getNamespace(), "/" + location.location().getPath()), entry.getValue(), GenericUtils.getItems(location)));
            }
        }
    }

    @NotNull
    private static EmiRecipeCategory createCategory(LootCategory<?> category) {
        return new EmiRecipeCategory(Utils.modLoc(category.getKey()), (EmiRenderable)EmiStack.of((ItemStack)category.getIcon()));
    }
}

