/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBaseLoot;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;

public class EmiEntityLoot
extends EmiBaseLoot {
    private final Entity entity;

    public EmiEntityLoot(EmiRecipeCategory category, ResourceLocation id, Entity entity, LootTable lootTable, List<Item> items) {
        super(category, id, lootTable, 0, 48, items);
        this.entity = entity;
        SpawnEggItem spawnEgg = SpawnEggItem.byId((EntityType)entity.getType());
        if (spawnEgg != null) {
            this.catalysts = List.of(EmiStack.of((ItemLike)spawnEgg));
        }
    }

    @Override
    public void addWidgets(final WidgetHolder widgetHolder) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            int length = Minecraft.getInstance().font.width((FormattedText)this.entity.getDisplayName());
            widgetHolder.add(new Widget(){
                private static final int WIDGET_SIZE = 36;
                final Bounds bounds;
                final Rect rect;
                {
                    this.bounds = new Bounds((widgetHolder.getWidth() - 36) / 2, 10, 36, 36);
                    this.rect = new Rect(this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height());
                }

                public Bounds getBounds() {
                    return this.bounds;
                }

                public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                    GenericUtils.renderEntity(EmiEntityLoot.this.entity, this.rect, widgetHolder.getWidth(), guiGraphics, mouseX, mouseY);
                }
            });
            widgetHolder.addText(this.entity.getDisplayName(), (widgetHolder.getWidth() - length) / 2, 0, 0, false);
            super.addWidgets(widgetHolder);
        }
        this.catalysts.forEach(catalyst -> widgetHolder.addSlot(catalyst, 0, 0));
    }

    public int getDisplayHeight() {
        return 48 + this.getItemsHeight();
    }
}

