/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.mixin.MixinBushBlock;
import com.yanny.ali.plugin.client.WidgetUtils;
import com.yanny.ali.registries.LootCategory;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class JeiBlockLoot
extends JeiBaseLoot<BlockLootType, Block> {
    private final ClientLevel level;

    public JeiBlockLoot(IGuiHelper guiHelper, RecipeType<BlockLootType> recipeType, LootCategory<Block> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
        this.level = Minecraft.getInstance().level;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, BlockLootType recipe, IFocusGroup iFocusGroup) {
        boolean isSpecial;
        super.setRecipe(builder, recipe, iFocusGroup);
        boolean bl = isSpecial = recipe.block() instanceof BushBlock || recipe.block().asItem() == Items.AIR;
        if (!isSpecial) {
            builder.addSlot(RecipeIngredientRole.INPUT, 73, 1).addItemStack(recipe.block().asItem().getDefaultInstance());
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(BlockLootType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        boolean isSpecial = recipe.block() instanceof BushBlock || recipe.block().asItem() == Items.AIR;
        boolean isPlant = recipe.block() instanceof BushBlock;
        BlockState blockState = recipe.block().defaultBlockState();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (isSpecial) {
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            poseStack.translate(72.0f, 4.0f, 0.0f);
            WidgetUtils.blitNineSliced(guiGraphics, WidgetUtils.TEXTURE_LOC, -4, -4, 24, 24, 1, 1, 1, 1, 16, 16, 2, 2);
            if (isPlant) {
                MixinBushBlock bushBlock;
                poseStack.translate(14.0f, 8.0f, 100.0f);
                poseStack.scale(9.0f, -9.0f, 9.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                blockRenderer.renderSingleBlock(blockState, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
                BlockState farmland = Blocks.FARMLAND.defaultBlockState();
                Block block = recipe.block();
                BlockState base = block instanceof MixinBushBlock && (bushBlock = (MixinBushBlock)block).invokeMayPlaceOn(farmland, (BlockGetter)this.level, BlockPos.ZERO) ? farmland : Blocks.GRASS_BLOCK.defaultBlockState();
                poseStack.translate(0.0f, -1.0f, 0.0f);
                blockRenderer.renderSingleBlock(base, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
            } else {
                poseStack.translate(21.0, 16.5, 100.0);
                poseStack.scale(18.0f, -18.0f, 18.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
                blockRenderer.renderSingleBlock(blockState, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
                poseStack.translate(0.0f, -1.0f, 0.0f);
            }
        } else {
            poseStack.translate(72.0f, 0.0f, 0.0f);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, 0, 0);
        }
        poseStack.popPose();
        if (isSpecial && mouseX >= 68.0 && mouseX < 92.0 && mouseY >= 0.0 && mouseY < 24.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)recipe.block().getDescriptionId()), (int)mouseX, (int)mouseY);
        }
    }

    @Override
    int getYOffset(BlockLootType recipe) {
        boolean isSpecial = recipe.block() instanceof BushBlock || recipe.block().asItem() == Items.AIR;
        return isSpecial ? 30 : 22;
    }
}

