/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.registries.LootCategory;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class JeiEntityLoot
extends JeiBaseLoot<EntityLootType, Entity> {
    private static final int WIDGET_SIZE = 36;

    public JeiEntityLoot(IGuiHelper guiHelper, RecipeType<EntityLootType> recipeType, LootCategory<Entity> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, EntityLootType recipe, IFocusGroup iFocusGroup) {
        super.setRecipe(builder, recipe, iFocusGroup);
        SpawnEggItem spawnEgg = SpawnEggItem.byId((EntityType)recipe.entity().getType());
        if (spawnEgg != null) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1).addItemStack(spawnEgg.getDefaultInstance());
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(EntityLootType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        this.guiHelper.getSlotDrawable().draw(guiGraphics, 0, 0);
        guiGraphics.drawString(font, recipe.entity().getDisplayName(), (162 - font.width((FormattedText)recipe.entity().getDisplayName())) / 2, 0, 0, false);
        GenericUtils.renderEntity(recipe.entity(), new Rect(63, 10, 36, 36), 162, guiGraphics, (int)mouseX, (int)mouseY);
    }

    @Override
    int getYOffset(EntityLootType recipe) {
        return 48;
    }
}

