/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ali.registries.GameplayLootCategory;
import com.yanny.ali.registries.LootCategory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class LootCategoryProvider
implements DataProvider {
    private final PackOutput generator;
    private final Set<LootCategory<?>> categories = new HashSet();

    public LootCategoryProvider(PackOutput generator) {
        this.generator = generator;
    }

    public void generate() {
        this.addGameplayCategory("chest_loot", Items.CHEST, List.of(Pattern.compile("^chests/.*$")));
        this.addGameplayCategory("fishing_loot", Items.FISHING_ROD, List.of(Pattern.compile("^gameplay/fishing/.*$")));
        this.addGameplayCategory("archaeology_loot", Items.DECORATED_POT, List.of(Pattern.compile("^archaeology/.*$")));
        this.addGameplayCategory("hero_loot", Items.EMERALD, List.of(Pattern.compile("^gameplay/hero_of_the_village/.*$")));
    }

    protected void addGameplayCategory(String key, Item icon, List<Pattern> prefix) {
        this.categories.add(new GameplayLootCategory(key, new ItemStack((ItemLike)icon), LootCategory.Type.GAMEPLAY, prefix));
    }

    @NotNull
    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])this.categories.stream().map(category -> {
            Path output = this.generator.getOutputFolder().resolve("assets/ali/loot_categories/" + category.getKey() + ".json");
            return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)LootCategoryProvider.toJson(category), (Path)output);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String getName() {
        return "loot_categories";
    }

    @NotNull
    private static JsonElement toJson(LootCategory<?> category) {
        GameplayLootCategory lootCategory;
        JsonObject object = new JsonObject();
        object.addProperty("type", category.getType().name());
        object.addProperty("icon", BuiltInRegistries.ITEM.getKey((Object)category.getIcon().getItem()).toString());
        object.addProperty("key", category.getKey());
        if (Objects.requireNonNull(category.getType()) == LootCategory.Type.GAMEPLAY && category instanceof GameplayLootCategory && (lootCategory = (GameplayLootCategory)category).getPrefix() != null) {
            JsonArray array = new JsonArray();
            lootCategory.getPrefix().forEach(p -> array.add(p.pattern()));
            object.add("prefix", (JsonElement)array);
        }
        return object;
    }
}

