/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.EntityHasScoreCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ConditionTooltipUtils {
    @NotNull
    public static List<Component> getAllOfTooltip(IClientUtils utils, int pad, AllOfCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.all_of", new Object[0])));
        components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, pad + 1, cond.terms));
        return components;
    }

    @NotNull
    public static List<Component> getAnyOfTooltip(IClientUtils utils, int pad, AnyOfCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.any_of", new Object[0])));
        components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, pad + 1, cond.terms));
        return components;
    }

    @NotNull
    public static List<Component> getBlockStatePropertyTooltip(IClientUtils utils, int pad, LootItemBlockStatePropertyCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.block_state_property", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, cond.block(), GenericTooltipUtils::getBlockTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, cond.properties(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getDamageSourcePropertiesTooltip(IClientUtils utils, int pad, DamageSourceCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.damage_source_properties", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, cond.predicate(), GenericTooltipUtils::getDamageSourcePredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityPropertiesTooltip(IClientUtils utils, int pad, LootItemEntityPropertyCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.entity_properties", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.target", cond.entityTarget()));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.predicate", cond.predicate(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityScoresTooltip(IClientUtils utils, int pad, EntityHasScoreCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.entity_scores", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.target", cond.entityTarget()));
        if (!cond.scores().isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.scores", new Object[0])));
            cond.scores().forEach((score, range) -> {
                components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.translatable("ali.property.value.score", score)));
                components.addAll(GenericTooltipUtils.getIntRangeTooltip(utils, pad + 3, "ali.property.value.limit", range));
            });
        }
        return components;
    }

    @NotNull
    public static List<Component> getInvertedTooltip(IClientUtils utils, int pad, InvertedLootItemCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.inverted", new Object[0])));
        components.addAll(utils.getConditionTooltip(utils, pad + 1, cond.term()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getKilledByPlayerTooltip(IClientUtils ignoredUtils, int pad, LootItemKilledByPlayerCondition ignoredCond) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.killed_by_player", new Object[0])));
    }

    @NotNull
    public static List<Component> getLocationCheckTooltip(IClientUtils utils, int pad, LocationCheck cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.location_check", new Object[0])));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.location", cond.predicate(), GenericTooltipUtils::getLocationPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.offset", cond.offset(), GenericTooltipUtils::getBlockPosTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getMatchToolTooltip(IClientUtils utils, int pad, MatchTool cond) {
        return new LinkedList<Component>(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.type.condition.match_tool", cond.predicate(), GenericTooltipUtils::getItemPredicateTooltip));
    }

    @NotNull
    public static List<Component> getRandomChanceTooltip(IClientUtils utils, int pad, LootItemRandomChanceCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.random_chance", new Object[0])));
        components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.probability", Float.valueOf(cond.probability())));
        return components;
    }

    @NotNull
    public static List<Component> getRandomChanceWithLootingTooltip(IClientUtils utils, int pad, LootItemRandomChanceWithLootingCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.random_chance_with_looting", new Object[0])));
        components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.percent", Float.valueOf(cond.percent())));
        components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.multiplier", Float.valueOf(cond.lootingMultiplier())));
        return components;
    }

    @NotNull
    public static List<Component> getReferenceTooltip(IClientUtils utils, int pad, ConditionReference cond) {
        return new LinkedList<Component>(GenericTooltipUtils.getResourceKeyTooltip(utils, pad, "ali.type.condition.reference", cond.name()));
    }

    public static @Unmodifiable @NotNull List<Component> getSurvivesExplosionTooltip(IClientUtils ignoredUtils, int pad, ExplosionCondition ignoredCond) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.survives_explosion", new Object[0])));
    }

    @NotNull
    public static List<Component> getTableBonusTooltip(IClientUtils utils, int pad, BonusLevelTableCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.table_bonus", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, cond.enchantment(), GenericTooltipUtils::getEnchantmentTooltip));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.values", cond.values().toString()));
        return components;
    }

    @NotNull
    public static List<Component> getTimeCheckTooltip(IClientUtils utils, int pad, TimeCheck cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.time_check", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.period", cond.period(), GenericTooltipUtils::getLongTooltip));
        components.addAll(GenericTooltipUtils.getIntRangeTooltip(utils, pad + 1, "ali.property.value.value", cond.value()));
        return components;
    }

    @NotNull
    public static List<Component> getValueCheckTooltip(IClientUtils utils, int pad, ValueCheckCondition cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.value_check", new Object[0])));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.provider", cond.provider()));
        components.addAll(GenericTooltipUtils.getIntRangeTooltip(utils, pad + 1, "ali.property.value.range", cond.range()));
        return components;
    }

    @NotNull
    public static List<Component> getWeatherCheckTooltip(IClientUtils utils, int pad, WeatherCheck cond) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.condition.weather_check", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_raining", cond.isRaining(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_thundering", cond.isThundering(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }
}

