/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.jetbrains.annotations.NotNull;

public class EntitySubPredicateTooltipUtils {
    @NotNull
    public static List<Component> getLightningBoltPredicateTooltip(IClientUtils utils, int pad, LightningBoltPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.lightning_bolt", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.blocks_on_fire", predicate.blocksSetOnFire()));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.stuck_entity", predicate.entityStruck(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getFishingHookPredicateTooltip(IClientUtils utils, int pad, FishingHookPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.fishing_hook", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.in_open_water", predicate.inOpenWater(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getPlayerPredicateTooltip(IClientUtils utils, int pad, PlayerPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.player", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", predicate.level()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, predicate.gameType(), GenericTooltipUtils::getGameTypeTooltip));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.stats", predicate.stats(), GenericTooltipUtils::getStatMatcherTooltip));
        components.addAll(GenericTooltipUtils.getRecipesTooltip(utils, pad + 1, (Object2BooleanMap<ResourceLocation>)predicate.recipes()));
        components.addAll(GenericTooltipUtils.getAdvancementsTooltip(utils, pad + 1, predicate.advancements()));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.looking_at", predicate.lookingAt(), GenericTooltipUtils::getEntityPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSlimePredicateTooltip(IClientUtils utils, int pad, SlimePredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.slime", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.size", predicate.size()));
        return components;
    }

    @NotNull
    public static List<Component> getRaiderPredicateTooltip(IClientUtils utils, int pad, RaiderPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.entity_sub_predicate.raider", new Object[0])));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_raid", predicate.hasRaid()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.is_captain", predicate.isCaptain()));
        return components;
    }

    @NotNull
    public static <V> List<Component> getVariantPredicateTooltip(IClientUtils utils, int pad, EntitySubPredicates.EntityVariantPredicateType.Instance predicate) {
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.type", BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, predicate.codec()));
        Object object = predicate.variant;
        if (object instanceof Enum) {
            Enum variant = (Enum)object;
            components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.variant", variant));
        }
        return components;
    }

    @NotNull
    public static <V> List<Component> getHolderVariantPredicateTooltip(IClientUtils utils, int pad, EntitySubPredicates.EntityHolderVariantPredicateType.Instance predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad, "ali.property.value.type", BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, predicate.codec()));
        components.addAll(GenericTooltipUtils.getHolderSetTooltip(utils, pad + 1, "ali.property.branch.variants", predicate.variants, (u, i, v) -> {
            if (v instanceof CatVariant) {
                CatVariant catVariant = (CatVariant)v;
                return GenericTooltipUtils.getBuiltInRegistryTooltip(u, i, "ali.property.value.variant", BuiltInRegistries.CAT_VARIANT, catVariant);
            }
            if (v instanceof PaintingVariant) {
                PaintingVariant paintingVariant = (PaintingVariant)v;
                return GenericTooltipUtils.getBuiltInRegistryTooltip(u, i, "ali.property.value.variant", BuiltInRegistries.PAINTING_VARIANT, paintingVariant);
            }
            if (v instanceof FrogVariant) {
                FrogVariant frogVariant = (FrogVariant)v;
                return GenericTooltipUtils.getBuiltInRegistryTooltip(u, i, "ali.property.value.variant", BuiltInRegistries.FROG_VARIANT, frogVariant);
            }
            if (v instanceof WolfVariant) {
                WolfVariant wolfVariant = (WolfVariant)v;
                return GenericTooltipUtils.getRegistryTooltip(u, i, "ali.property.value.variant", Registries.WOLF_VARIANT, wolfVariant);
            }
            return List.of();
        }));
        return components;
    }
}

