/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class CompositeWidget
implements IEntryWidget {
    private final Rect bounds;
    protected final List<IWidget> widgets;
    private final LootPoolEntryContainer entry;
    private final IClientUtils utils;

    public CompositeWidget(IWidgetUtils utils, LootPoolEntryContainer entry, int x, int y, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        CompositeEntryBase compositeEntry = (CompositeEntryBase)entry;
        LinkedList<LootItemCondition> allConditions = new LinkedList<LootItemCondition>(conditions);
        allConditions.addAll(compositeEntry.conditions);
        Pair<List<IEntryWidget>, Rect> pair = utils.createWidgets(utils, compositeEntry.children, x, y, List.copyOf(functions), allConditions);
        this.widgets = new LinkedList<IWidget>((Collection)pair.getFirst());
        this.bounds = (Rect)pair.getSecond();
        this.entry = entry;
        this.utils = utils;
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public LootPoolEntryContainer getLootEntry() {
        return this.entry;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().y());
            }
            lastDirection = direction;
        }
        int top = this.bounds.y() + 18;
        int height = lastY - this.bounds.y() - 9;
        WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 3, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().y() > this.bounds.y() + 18) {
                WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 4, widget.getRect().y() + 8, 3, 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<Component> components = new LinkedList<Component>();
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @NotNull
    public static Rect getBounds(IClientUtils utils, LootPoolEntryContainer entry, int x, int y) {
        return utils.getBounds(utils, ((CompositeEntryBase)entry).children, x, y);
    }
}

